@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Entity representing the reference to the deployment parameters.
 * @property contentVersion If included, must match the ContentVersion in the template.
 * @property uri The URI of the parameters file.
 */
public data class ParametersLinkResponse(
    public val contentVersion: String? = null,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ParametersLinkResponse):
            ParametersLinkResponse = ParametersLinkResponse(
            contentVersion = javaType.contentVersion().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri(),
        )
    }
}
