@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin

import com.pulumi.azurenative.saas.kotlin.outputs.SaasResourceResponseProperties
import com.pulumi.azurenative.saas.kotlin.outputs.SaasResourceResponseProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SaasSubscriptionLevel].
 */
@PulumiTagMarker
public class SaasSubscriptionLevelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SaasSubscriptionLevelArgs = SaasSubscriptionLevelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SaasSubscriptionLevelArgsBuilder.() -> Unit) {
        val builder = SaasSubscriptionLevelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SaasSubscriptionLevel {
        val builtJavaResource =
            com.pulumi.azurenative.saas.SaasSubscriptionLevel(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SaasSubscriptionLevel(builtJavaResource)
    }
}

/**
 * SaaS REST API resource definition.
 * Azure REST API version: 2018-03-01-beta. Prior API version in Azure Native 1.x: 2018-03-01-beta.
 * ## Example Usage
 * ### Create subscription level SaaS resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var saasSubscriptionLevel = new AzureNative.SaaS.SaasSubscriptionLevel("saasSubscriptionLevel", new()
 *     {
 *         Location = "global",
 *         Name = "MyContosoSubscription",
 *         Properties = new AzureNative.SaaS.Inputs.SaasCreationPropertiesArgs
 *         {
 *             OfferId = "contosoOffer",
 *             PaymentChannelMetadata =
 *             {
 *                 { "AzureSubscriptionId", "155af98a-3205-47e7-883b-a2ab9db9f88d" },
 *             },
 *             PaymentChannelType = AzureNative.SaaS.PaymentChannelType.SubscriptionDelegated,
 *             PublisherId = "microsoft-contoso",
 *             SaasResourceName = "MyContosoSubscription",
 *             SkuId = "free",
 *             TermId = "hjdtn7tfnxcy",
 *         },
 *         ResourceGroupName = "my-saas-rg",
 *         ResourceName = "MyContosoSubscription",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/saas/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := saas.NewSaasSubscriptionLevel(ctx, "saasSubscriptionLevel", &saas.SaasSubscriptionLevelArgs{
 * 			Location: pulumi.String("global"),
 * 			Name:     pulumi.String("MyContosoSubscription"),
 * 			Properties: &saas.SaasCreationPropertiesArgs{
 * 				OfferId: pulumi.String("contosoOffer"),
 * 				PaymentChannelMetadata: pulumi.StringMap{
 * 					"AzureSubscriptionId": pulumi.String("155af98a-3205-47e7-883b-a2ab9db9f88d"),
 * 				},
 * 				PaymentChannelType: pulumi.String(saas.PaymentChannelTypeSubscriptionDelegated),
 * 				PublisherId:        pulumi.String("microsoft-contoso"),
 * 				SaasResourceName:   pulumi.String("MyContosoSubscription"),
 * 				SkuId:              pulumi.String("free"),
 * 				TermId:             pulumi.String("hjdtn7tfnxcy"),
 * 			},
 * 			ResourceGroupName: pulumi.String("my-saas-rg"),
 * 			ResourceName:      pulumi.String("MyContosoSubscription"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.saas.SaasSubscriptionLevel;
 * import com.pulumi.azurenative.saas.SaasSubscriptionLevelArgs;
 * import com.pulumi.azurenative.saas.inputs.SaasCreationPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var saasSubscriptionLevel = new SaasSubscriptionLevel("saasSubscriptionLevel", SaasSubscriptionLevelArgs.builder()
 *             .location("global")
 *             .name("MyContosoSubscription")
 *             .properties(SaasCreationPropertiesArgs.builder()
 *                 .offerId("contosoOffer")
 *                 .paymentChannelMetadata(Map.of("AzureSubscriptionId", "155af98a-3205-47e7-883b-a2ab9db9f88d"))
 *                 .paymentChannelType("SubscriptionDelegated")
 *                 .publisherId("microsoft-contoso")
 *                 .saasResourceName("MyContosoSubscription")
 *                 .skuId("free")
 *                 .termId("hjdtn7tfnxcy")
 *                 .build())
 *             .resourceGroupName("my-saas-rg")
 *             .resourceName("MyContosoSubscription")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:saas:SaasSubscriptionLevel MyContosoSubscription /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SaaS/resources/{resourceName}
 * ```
 */
public class SaasSubscriptionLevel internal constructor(
    override val javaResource: com.pulumi.azurenative.saas.SaasSubscriptionLevel,
) : KotlinCustomResource(javaResource, SaasSubscriptionLevelMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * saas properties
     */
    public val properties: Output<SaasResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * the resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SaasSubscriptionLevelMapper : ResourceMapper<SaasSubscriptionLevel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.saas.SaasSubscriptionLevel::class == javaResource::class

    override fun map(javaResource: Resource): SaasSubscriptionLevel =
        SaasSubscriptionLevel(javaResource as com.pulumi.azurenative.saas.SaasSubscriptionLevel)
}

/**
 * @see [SaasSubscriptionLevel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SaasSubscriptionLevel].
 */
public suspend fun saasSubscriptionLevel(
    name: String,
    block: suspend SaasSubscriptionLevelResourceBuilder.() -> Unit,
): SaasSubscriptionLevel {
    val builder = SaasSubscriptionLevelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SaasSubscriptionLevel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun saasSubscriptionLevel(name: String): SaasSubscriptionLevel {
    val builder = SaasSubscriptionLevelResourceBuilder()
    builder.name(name)
    return builder.build()
}
