@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin.inputs

import com.pulumi.azurenative.saas.inputs.GetSaasSubscriptionLevelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the resource.
 */
public data class GetSaasSubscriptionLevelPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.saas.inputs.GetSaasSubscriptionLevelPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.saas.inputs.GetSaasSubscriptionLevelPlainArgs =
        com.pulumi.azurenative.saas.inputs.GetSaasSubscriptionLevelPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSaasSubscriptionLevelPlainArgs].
 */
@PulumiTagMarker
public class GetSaasSubscriptionLevelPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jggkoedyfjgqkgim")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("buiqelxebwlgsiis")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetSaasSubscriptionLevelPlainArgs = GetSaasSubscriptionLevelPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
