@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * SaaS REST API resource definition.
 * @property id The resource uri
 * @property name The name of the resource
 * @property properties saas properties
 * @property tags the resource tags.
 * @property type Resource type.
 */
public data class GetSaasSubscriptionLevelResult(
    public val id: String,
    public val name: String,
    public val properties: SaasResourceResponseProperties,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.saas.outputs.GetSaasSubscriptionLevelResult):
            GetSaasSubscriptionLevelResult = GetSaasSubscriptionLevelResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.saas.kotlin.outputs.SaasResourceResponseProperties.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
