@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.GetJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobCollectionName The job collection name.
 * @property jobName The job name.
 * @property resourceGroupName The resource group name.
 */
public data class GetJobPlainArgs(
    public val jobCollectionName: String,
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.GetJobPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.GetJobPlainArgs =
        com.pulumi.azurenative.scheduler.inputs.GetJobPlainArgs.builder()
            .jobCollectionName(jobCollectionName.let({ args0 -> args0 }))
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobPlainArgs].
 */
@PulumiTagMarker
public class GetJobPlainArgsBuilder internal constructor() {
    private var jobCollectionName: String? = null

    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The job collection name.
     */
    @JvmName("wkhsgwmyqtgurnda")
    public suspend fun jobCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobCollectionName = mapped
    }

    /**
     * @param value The job name.
     */
    @JvmName("kcdkgcoqkxndupox")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("iwjmljqurgqeassm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJobPlainArgs = GetJobPlainArgs(
        jobCollectionName = jobCollectionName ?: throw PulumiNullFieldException("jobCollectionName"),
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
