@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.JobActionArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.JobActionType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property errorAction Gets or sets the error action.
 * @property queueMessage Gets or sets the storage queue message.
 * @property request Gets or sets the http requests.
 * @property retryPolicy Gets or sets the retry policy.
 * @property serviceBusQueueMessage Gets or sets the service bus queue message.
 * @property serviceBusTopicMessage Gets or sets the service bus topic message.
 * @property type Gets or sets the job action type.
 */
public data class JobActionArgs(
    public val errorAction: Output<JobErrorActionArgs>? = null,
    public val queueMessage: Output<StorageQueueMessageArgs>? = null,
    public val request: Output<HttpRequestArgs>? = null,
    public val retryPolicy: Output<RetryPolicyArgs>? = null,
    public val serviceBusQueueMessage: Output<ServiceBusQueueMessageArgs>? = null,
    public val serviceBusTopicMessage: Output<ServiceBusTopicMessageArgs>? = null,
    public val type: Output<JobActionType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.JobActionArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.JobActionArgs =
        com.pulumi.azurenative.scheduler.inputs.JobActionArgs.builder()
            .errorAction(errorAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queueMessage(queueMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .request(request?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceBusQueueMessage(
                serviceBusQueueMessage?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serviceBusTopicMessage(
                serviceBusTopicMessage?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobActionArgs].
 */
@PulumiTagMarker
public class JobActionArgsBuilder internal constructor() {
    private var errorAction: Output<JobErrorActionArgs>? = null

    private var queueMessage: Output<StorageQueueMessageArgs>? = null

    private var request: Output<HttpRequestArgs>? = null

    private var retryPolicy: Output<RetryPolicyArgs>? = null

    private var serviceBusQueueMessage: Output<ServiceBusQueueMessageArgs>? = null

    private var serviceBusTopicMessage: Output<ServiceBusTopicMessageArgs>? = null

    private var type: Output<JobActionType>? = null

    /**
     * @param value Gets or sets the error action.
     */
    @JvmName("pafgncmuiskjuauo")
    public suspend fun errorAction(`value`: Output<JobErrorActionArgs>) {
        this.errorAction = value
    }

    /**
     * @param value Gets or sets the storage queue message.
     */
    @JvmName("xfjerfdhjfvfacjw")
    public suspend fun queueMessage(`value`: Output<StorageQueueMessageArgs>) {
        this.queueMessage = value
    }

    /**
     * @param value Gets or sets the http requests.
     */
    @JvmName("wpvkcbcqtbbaavbg")
    public suspend fun request(`value`: Output<HttpRequestArgs>) {
        this.request = value
    }

    /**
     * @param value Gets or sets the retry policy.
     */
    @JvmName("drrjamecewofbdxb")
    public suspend fun retryPolicy(`value`: Output<RetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value Gets or sets the service bus queue message.
     */
    @JvmName("woyhwndyuyupokoc")
    public suspend fun serviceBusQueueMessage(`value`: Output<ServiceBusQueueMessageArgs>) {
        this.serviceBusQueueMessage = value
    }

    /**
     * @param value Gets or sets the service bus topic message.
     */
    @JvmName("aphbbdjkkcwwknxp")
    public suspend fun serviceBusTopicMessage(`value`: Output<ServiceBusTopicMessageArgs>) {
        this.serviceBusTopicMessage = value
    }

    /**
     * @param value Gets or sets the job action type.
     */
    @JvmName("oqthmhassrbxvsgb")
    public suspend fun type(`value`: Output<JobActionType>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the error action.
     */
    @JvmName("ohucgpomaaaftukm")
    public suspend fun errorAction(`value`: JobErrorActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorAction = mapped
    }

    /**
     * @param argument Gets or sets the error action.
     */
    @JvmName("mlsxtmnkernvfamw")
    public suspend fun errorAction(argument: suspend JobErrorActionArgsBuilder.() -> Unit) {
        val toBeMapped = JobErrorActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.errorAction = mapped
    }

    /**
     * @param value Gets or sets the storage queue message.
     */
    @JvmName("vngybqvymiokixst")
    public suspend fun queueMessage(`value`: StorageQueueMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueMessage = mapped
    }

    /**
     * @param argument Gets or sets the storage queue message.
     */
    @JvmName("fnwpjnyfhvadhnhe")
    public suspend fun queueMessage(argument: suspend StorageQueueMessageArgsBuilder.() -> Unit) {
        val toBeMapped = StorageQueueMessageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.queueMessage = mapped
    }

    /**
     * @param value Gets or sets the http requests.
     */
    @JvmName("vjypeobqthpcoepc")
    public suspend fun request(`value`: HttpRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.request = mapped
    }

    /**
     * @param argument Gets or sets the http requests.
     */
    @JvmName("vkxfkrkuylqfhisc")
    public suspend fun request(argument: suspend HttpRequestArgsBuilder.() -> Unit) {
        val toBeMapped = HttpRequestArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.request = mapped
    }

    /**
     * @param value Gets or sets the retry policy.
     */
    @JvmName("mqnuvgvtljhjlxfj")
    public suspend fun retryPolicy(`value`: RetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument Gets or sets the retry policy.
     */
    @JvmName("hlcbcsmomceoyyps")
    public suspend fun retryPolicy(argument: suspend RetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    /**
     * @param value Gets or sets the service bus queue message.
     */
    @JvmName("iguudfpawfematus")
    public suspend fun serviceBusQueueMessage(`value`: ServiceBusQueueMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusQueueMessage = mapped
    }

    /**
     * @param argument Gets or sets the service bus queue message.
     */
    @JvmName("xvsuwcynotjfskyq")
    public suspend
    fun serviceBusQueueMessage(argument: suspend ServiceBusQueueMessageArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceBusQueueMessageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceBusQueueMessage = mapped
    }

    /**
     * @param value Gets or sets the service bus topic message.
     */
    @JvmName("gymaybsxpdbyrpap")
    public suspend fun serviceBusTopicMessage(`value`: ServiceBusTopicMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusTopicMessage = mapped
    }

    /**
     * @param argument Gets or sets the service bus topic message.
     */
    @JvmName("xrgxvrcqoheafgmq")
    public suspend
    fun serviceBusTopicMessage(argument: suspend ServiceBusTopicMessageArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceBusTopicMessageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceBusTopicMessage = mapped
    }

    /**
     * @param value Gets or sets the job action type.
     */
    @JvmName("yrfycvsttqmiqppi")
    public suspend fun type(`value`: JobActionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JobActionArgs = JobActionArgs(
        errorAction = errorAction,
        queueMessage = queueMessage,
        request = request,
        retryPolicy = retryPolicy,
        serviceBusQueueMessage = serviceBusQueueMessage,
        serviceBusTopicMessage = serviceBusTopicMessage,
        type = type,
    )
}
