@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.JobRecurrenceArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.RecurrenceFrequency
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property count Gets or sets the maximum number of times that the job should run.
 * @property endTime Gets or sets the time at which the job will complete.
 * @property frequency Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
 * @property interval Gets or sets the interval between retries.
 * @property schedule
 */
public data class JobRecurrenceArgs(
    public val count: Output<Int>? = null,
    public val endTime: Output<String>? = null,
    public val frequency: Output<RecurrenceFrequency>? = null,
    public val interval: Output<Int>? = null,
    public val schedule: Output<JobRecurrenceScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.JobRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.JobRecurrenceArgs =
        com.pulumi.azurenative.scheduler.inputs.JobRecurrenceArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .frequency(frequency?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobRecurrenceArgs].
 */
@PulumiTagMarker
public class JobRecurrenceArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var endTime: Output<String>? = null

    private var frequency: Output<RecurrenceFrequency>? = null

    private var interval: Output<Int>? = null

    private var schedule: Output<JobRecurrenceScheduleArgs>? = null

    /**
     * @param value Gets or sets the maximum number of times that the job should run.
     */
    @JvmName("gkvbuloghgifcfjf")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Gets or sets the time at which the job will complete.
     */
    @JvmName("urhbityfcfktoxec")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
     */
    @JvmName("ucviajdlbcnecbhf")
    public suspend fun frequency(`value`: Output<RecurrenceFrequency>) {
        this.frequency = value
    }

    /**
     * @param value Gets or sets the interval between retries.
     */
    @JvmName("cogdodyilkdfiuat")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value
     */
    @JvmName("lkbdwrldsjaodbse")
    public suspend fun schedule(`value`: Output<JobRecurrenceScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Gets or sets the maximum number of times that the job should run.
     */
    @JvmName("mtycgxmwrjfseowh")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Gets or sets the time at which the job will complete.
     */
    @JvmName("marjiaghidlpuphq")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
     */
    @JvmName("pjgwvbsxgnufvqnn")
    public suspend fun frequency(`value`: RecurrenceFrequency?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Gets or sets the interval between retries.
     */
    @JvmName("clnrrielglitlugk")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value
     */
    @JvmName("qbbxgrrbnaakjeqw")
    public suspend fun schedule(`value`: JobRecurrenceScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ouccsahbhkspniql")
    public suspend fun schedule(argument: suspend JobRecurrenceScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = JobRecurrenceScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    internal fun build(): JobRecurrenceArgs = JobRecurrenceArgs(
        count = count,
        endTime = endTime,
        frequency = frequency,
        interval = interval,
        schedule = schedule,
    )
}
