@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.OAuthAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property audience Gets or sets the audience.
 * @property clientId Gets or sets the client identifier.
 * @property secret Gets or sets the secret, return value will always be empty.
 * @property tenant Gets or sets the tenant.
 * @property type Gets or sets the HTTP authentication type.
 * Expected value is 'ActiveDirectoryOAuth'.
 */
public data class OAuthAuthenticationArgs(
    public val audience: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val secret: Output<String>? = null,
    public val tenant: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.OAuthAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.OAuthAuthenticationArgs =
        com.pulumi.azurenative.scheduler.inputs.OAuthAuthenticationArgs.builder()
            .audience(audience?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .secret(secret?.applyValue({ args0 -> args0 }))
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OAuthAuthenticationArgs].
 */
@PulumiTagMarker
public class OAuthAuthenticationArgsBuilder internal constructor() {
    private var audience: Output<String>? = null

    private var clientId: Output<String>? = null

    private var secret: Output<String>? = null

    private var tenant: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Gets or sets the audience.
     */
    @JvmName("djbcovexksyskomg")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value Gets or sets the client identifier.
     */
    @JvmName("aaoqpxrxqnloxbgw")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Gets or sets the secret, return value will always be empty.
     */
    @JvmName("fhgouqjjethqptsm")
    public suspend fun secret(`value`: Output<String>) {
        this.secret = value
    }

    /**
     * @param value Gets or sets the tenant.
     */
    @JvmName("unjlqdrxjtjdrims")
    public suspend fun tenant(`value`: Output<String>) {
        this.tenant = value
    }

    /**
     * @param value Gets or sets the HTTP authentication type.
     * Expected value is 'ActiveDirectoryOAuth'.
     */
    @JvmName("iqdevvigkkumtkca")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the audience.
     */
    @JvmName("rgjmkhlckietyhxg")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value Gets or sets the client identifier.
     */
    @JvmName("cdplydwvfckpsgfw")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Gets or sets the secret, return value will always be empty.
     */
    @JvmName("hrsrbjkkhjqefepw")
    public suspend fun secret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    /**
     * @param value Gets or sets the tenant.
     */
    @JvmName("flbritntksuowgcv")
    public suspend fun tenant(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Gets or sets the HTTP authentication type.
     * Expected value is 'ActiveDirectoryOAuth'.
     */
    @JvmName("kexebitpivscmxhs")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OAuthAuthenticationArgs = OAuthAuthenticationArgs(
        audience = audience,
        clientId = clientId,
        secret = secret,
        tenant = tenant,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
