@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.RetryPolicyArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.RetryType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property retryCount Gets or sets the number of times a retry should be attempted.
 * @property retryInterval Gets or sets the retry interval between retries, specify duration in ISO 8601 format.
 * @property retryType Gets or sets the retry strategy to be used.
 */
public data class RetryPolicyArgs(
    public val retryCount: Output<Int>? = null,
    public val retryInterval: Output<String>? = null,
    public val retryType: Output<RetryType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.RetryPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.RetryPolicyArgs =
        com.pulumi.azurenative.scheduler.inputs.RetryPolicyArgs.builder()
            .retryCount(retryCount?.applyValue({ args0 -> args0 }))
            .retryInterval(retryInterval?.applyValue({ args0 -> args0 }))
            .retryType(retryType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RetryPolicyArgs].
 */
@PulumiTagMarker
public class RetryPolicyArgsBuilder internal constructor() {
    private var retryCount: Output<Int>? = null

    private var retryInterval: Output<String>? = null

    private var retryType: Output<RetryType>? = null

    /**
     * @param value Gets or sets the number of times a retry should be attempted.
     */
    @JvmName("sdmxynjmqoxylwuo")
    public suspend fun retryCount(`value`: Output<Int>) {
        this.retryCount = value
    }

    /**
     * @param value Gets or sets the retry interval between retries, specify duration in ISO 8601 format.
     */
    @JvmName("qjbwqiimacyowfhq")
    public suspend fun retryInterval(`value`: Output<String>) {
        this.retryInterval = value
    }

    /**
     * @param value Gets or sets the retry strategy to be used.
     */
    @JvmName("mejmfacfcporpogw")
    public suspend fun retryType(`value`: Output<RetryType>) {
        this.retryType = value
    }

    /**
     * @param value Gets or sets the number of times a retry should be attempted.
     */
    @JvmName("onnjamdkdohruihw")
    public suspend fun retryCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryCount = mapped
    }

    /**
     * @param value Gets or sets the retry interval between retries, specify duration in ISO 8601 format.
     */
    @JvmName("wlsgkmjfkfsbfhia")
    public suspend fun retryInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryInterval = mapped
    }

    /**
     * @param value Gets or sets the retry strategy to be used.
     */
    @JvmName("aigwwqmoxlqusytb")
    public suspend fun retryType(`value`: RetryType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryType = mapped
    }

    internal fun build(): RetryPolicyArgs = RetryPolicyArgs(
        retryCount = retryCount,
        retryInterval = retryInterval,
        retryType = retryType,
    )
}
