@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.ServiceBusAuthenticationArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.ServiceBusAuthenticationType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sasKey Gets or sets the SAS key.
 * @property sasKeyName Gets or sets the SAS key name.
 * @property type Gets or sets the authentication type.
 */
public data class ServiceBusAuthenticationArgs(
    public val sasKey: Output<String>? = null,
    public val sasKeyName: Output<String>? = null,
    public val type: Output<ServiceBusAuthenticationType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.ServiceBusAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.ServiceBusAuthenticationArgs =
        com.pulumi.azurenative.scheduler.inputs.ServiceBusAuthenticationArgs.builder()
            .sasKey(sasKey?.applyValue({ args0 -> args0 }))
            .sasKeyName(sasKeyName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServiceBusAuthenticationArgs].
 */
@PulumiTagMarker
public class ServiceBusAuthenticationArgsBuilder internal constructor() {
    private var sasKey: Output<String>? = null

    private var sasKeyName: Output<String>? = null

    private var type: Output<ServiceBusAuthenticationType>? = null

    /**
     * @param value Gets or sets the SAS key.
     */
    @JvmName("pgifffseynjjekwg")
    public suspend fun sasKey(`value`: Output<String>) {
        this.sasKey = value
    }

    /**
     * @param value Gets or sets the SAS key name.
     */
    @JvmName("ukobbikgurxolhns")
    public suspend fun sasKeyName(`value`: Output<String>) {
        this.sasKeyName = value
    }

    /**
     * @param value Gets or sets the authentication type.
     */
    @JvmName("geuugaplrdcxmmsn")
    public suspend fun type(`value`: Output<ServiceBusAuthenticationType>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the SAS key.
     */
    @JvmName("gnmnjelgioqjxaih")
    public suspend fun sasKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasKey = mapped
    }

    /**
     * @param value Gets or sets the SAS key name.
     */
    @JvmName("crubstesliqlhaha")
    public suspend fun sasKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasKeyName = mapped
    }

    /**
     * @param value Gets or sets the authentication type.
     */
    @JvmName("sxqdmlxlmevklvor")
    public suspend fun type(`value`: ServiceBusAuthenticationType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceBusAuthenticationArgs = ServiceBusAuthenticationArgs(
        sasKey = sasKey,
        sasKeyName = sasKeyName,
        type = type,
    )
}
