@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.ServiceBusBrokeredMessagePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentType Gets or sets the content type.
 * @property correlationId Gets or sets the correlation ID.
 * @property forcePersistence Gets or sets the force persistence.
 * @property label Gets or sets the label.
 * @property messageId Gets or sets the message ID.
 * @property partitionKey Gets or sets the partition key.
 * @property replyTo Gets or sets the reply to.
 * @property replyToSessionId Gets or sets the reply to session ID.
 * @property scheduledEnqueueTimeUtc Gets or sets the scheduled enqueue time UTC.
 * @property sessionId Gets or sets the session ID.
 * @property timeToLive Gets or sets the time to live.
 * @property to Gets or sets the to.
 * @property viaPartitionKey Gets or sets the via partition key.
 */
public data class ServiceBusBrokeredMessagePropertiesArgs(
    public val contentType: Output<String>? = null,
    public val correlationId: Output<String>? = null,
    public val forcePersistence: Output<Boolean>? = null,
    public val label: Output<String>? = null,
    public val messageId: Output<String>? = null,
    public val partitionKey: Output<String>? = null,
    public val replyTo: Output<String>? = null,
    public val replyToSessionId: Output<String>? = null,
    public val scheduledEnqueueTimeUtc: Output<String>? = null,
    public val sessionId: Output<String>? = null,
    public val timeToLive: Output<String>? = null,
    public val to: Output<String>? = null,
    public val viaPartitionKey: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.ServiceBusBrokeredMessagePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.scheduler.inputs.ServiceBusBrokeredMessagePropertiesArgs =
        com.pulumi.azurenative.scheduler.inputs.ServiceBusBrokeredMessagePropertiesArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .correlationId(correlationId?.applyValue({ args0 -> args0 }))
            .forcePersistence(forcePersistence?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .messageId(messageId?.applyValue({ args0 -> args0 }))
            .partitionKey(partitionKey?.applyValue({ args0 -> args0 }))
            .replyTo(replyTo?.applyValue({ args0 -> args0 }))
            .replyToSessionId(replyToSessionId?.applyValue({ args0 -> args0 }))
            .scheduledEnqueueTimeUtc(scheduledEnqueueTimeUtc?.applyValue({ args0 -> args0 }))
            .sessionId(sessionId?.applyValue({ args0 -> args0 }))
            .timeToLive(timeToLive?.applyValue({ args0 -> args0 }))
            .to(to?.applyValue({ args0 -> args0 }))
            .viaPartitionKey(viaPartitionKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceBusBrokeredMessagePropertiesArgs].
 */
@PulumiTagMarker
public class ServiceBusBrokeredMessagePropertiesArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var correlationId: Output<String>? = null

    private var forcePersistence: Output<Boolean>? = null

    private var label: Output<String>? = null

    private var messageId: Output<String>? = null

    private var partitionKey: Output<String>? = null

    private var replyTo: Output<String>? = null

    private var replyToSessionId: Output<String>? = null

    private var scheduledEnqueueTimeUtc: Output<String>? = null

    private var sessionId: Output<String>? = null

    private var timeToLive: Output<String>? = null

    private var to: Output<String>? = null

    private var viaPartitionKey: Output<String>? = null

    /**
     * @param value Gets or sets the content type.
     */
    @JvmName("cbngbbhcibxgxwtg")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Gets or sets the correlation ID.
     */
    @JvmName("rvavarpfkijhubgv")
    public suspend fun correlationId(`value`: Output<String>) {
        this.correlationId = value
    }

    /**
     * @param value Gets or sets the force persistence.
     */
    @JvmName("iqvpdxdralpwhnec")
    public suspend fun forcePersistence(`value`: Output<Boolean>) {
        this.forcePersistence = value
    }

    /**
     * @param value Gets or sets the label.
     */
    @JvmName("xtossyrwkevexmmi")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Gets or sets the message ID.
     */
    @JvmName("fgbpgwlwjkmcxmfq")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value Gets or sets the partition key.
     */
    @JvmName("gdggsovxjksptryy")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value Gets or sets the reply to.
     */
    @JvmName("pqfulsltaxpvyccf")
    public suspend fun replyTo(`value`: Output<String>) {
        this.replyTo = value
    }

    /**
     * @param value Gets or sets the reply to session ID.
     */
    @JvmName("ewssktluhilbanpb")
    public suspend fun replyToSessionId(`value`: Output<String>) {
        this.replyToSessionId = value
    }

    /**
     * @param value Gets or sets the scheduled enqueue time UTC.
     */
    @JvmName("povapalwlytbowqi")
    public suspend fun scheduledEnqueueTimeUtc(`value`: Output<String>) {
        this.scheduledEnqueueTimeUtc = value
    }

    /**
     * @param value Gets or sets the session ID.
     */
    @JvmName("mfduevcksyjdmuja")
    public suspend fun sessionId(`value`: Output<String>) {
        this.sessionId = value
    }

    /**
     * @param value Gets or sets the time to live.
     */
    @JvmName("nbyveegofuppiylh")
    public suspend fun timeToLive(`value`: Output<String>) {
        this.timeToLive = value
    }

    /**
     * @param value Gets or sets the to.
     */
    @JvmName("whhigvatolgnqqev")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value Gets or sets the via partition key.
     */
    @JvmName("djqihrxdfqvfnqys")
    public suspend fun viaPartitionKey(`value`: Output<String>) {
        this.viaPartitionKey = value
    }

    /**
     * @param value Gets or sets the content type.
     */
    @JvmName("ikbsukgadxldhiek")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Gets or sets the correlation ID.
     */
    @JvmName("khjvpexcqveahrgv")
    public suspend fun correlationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.correlationId = mapped
    }

    /**
     * @param value Gets or sets the force persistence.
     */
    @JvmName("nokvyqcxjbkfhgjj")
    public suspend fun forcePersistence(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forcePersistence = mapped
    }

    /**
     * @param value Gets or sets the label.
     */
    @JvmName("pqshdevafbqpbdcw")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Gets or sets the message ID.
     */
    @JvmName("uowdqvkbwffewcwm")
    public suspend fun messageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value Gets or sets the partition key.
     */
    @JvmName("ixlyffpelenxjtud")
    public suspend fun partitionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    /**
     * @param value Gets or sets the reply to.
     */
    @JvmName("vvrbsquvdokwmkgv")
    public suspend fun replyTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replyTo = mapped
    }

    /**
     * @param value Gets or sets the reply to session ID.
     */
    @JvmName("glfbgbsxpqhcallc")
    public suspend fun replyToSessionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replyToSessionId = mapped
    }

    /**
     * @param value Gets or sets the scheduled enqueue time UTC.
     */
    @JvmName("etexmjdwcmdukrsp")
    public suspend fun scheduledEnqueueTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledEnqueueTimeUtc = mapped
    }

    /**
     * @param value Gets or sets the session ID.
     */
    @JvmName("gvqngtmqnroiucxb")
    public suspend fun sessionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionId = mapped
    }

    /**
     * @param value Gets or sets the time to live.
     */
    @JvmName("aqtbtrjkthhfuxvq")
    public suspend fun timeToLive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToLive = mapped
    }

    /**
     * @param value Gets or sets the to.
     */
    @JvmName("fbtyttttsgkwaknb")
    public suspend fun to(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.to = mapped
    }

    /**
     * @param value Gets or sets the via partition key.
     */
    @JvmName("uwiqcsgrxiqbghgr")
    public suspend fun viaPartitionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viaPartitionKey = mapped
    }

    internal fun build(): ServiceBusBrokeredMessagePropertiesArgs =
        ServiceBusBrokeredMessagePropertiesArgs(
            contentType = contentType,
            correlationId = correlationId,
            forcePersistence = forcePersistence,
            label = label,
            messageId = messageId,
            partitionKey = partitionKey,
            replyTo = replyTo,
            replyToSessionId = replyToSessionId,
            scheduledEnqueueTimeUtc = scheduledEnqueueTimeUtc,
            sessionId = sessionId,
            timeToLive = timeToLive,
            to = to,
            viaPartitionKey = viaPartitionKey,
        )
}
