@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.ServiceBusTopicMessageArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.ServiceBusTransportType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property authentication Gets or sets the Service Bus authentication.
 * @property brokeredMessageProperties Gets or sets the brokered message properties.
 * @property customMessageProperties Gets or sets the custom message properties.
 * @property message Gets or sets the message.
 * @property namespace Gets or sets the namespace.
 * @property topicPath Gets or sets the topic path.
 * @property transportType Gets or sets the transport type.
 */
public data class ServiceBusTopicMessageArgs(
    public val authentication: Output<ServiceBusAuthenticationArgs>? = null,
    public val brokeredMessageProperties: Output<ServiceBusBrokeredMessagePropertiesArgs>? = null,
    public val customMessageProperties: Output<Map<String, String>>? = null,
    public val message: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val topicPath: Output<String>? = null,
    public val transportType: Output<ServiceBusTransportType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.ServiceBusTopicMessageArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.ServiceBusTopicMessageArgs =
        com.pulumi.azurenative.scheduler.inputs.ServiceBusTopicMessageArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .brokeredMessageProperties(
                brokeredMessageProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customMessageProperties(
                customMessageProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .message(message?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .topicPath(topicPath?.applyValue({ args0 -> args0 }))
            .transportType(transportType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServiceBusTopicMessageArgs].
 */
@PulumiTagMarker
public class ServiceBusTopicMessageArgsBuilder internal constructor() {
    private var authentication: Output<ServiceBusAuthenticationArgs>? = null

    private var brokeredMessageProperties: Output<ServiceBusBrokeredMessagePropertiesArgs>? = null

    private var customMessageProperties: Output<Map<String, String>>? = null

    private var message: Output<String>? = null

    private var namespace: Output<String>? = null

    private var topicPath: Output<String>? = null

    private var transportType: Output<ServiceBusTransportType>? = null

    /**
     * @param value Gets or sets the Service Bus authentication.
     */
    @JvmName("dnfsdxvxnnlrwkqu")
    public suspend fun authentication(`value`: Output<ServiceBusAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value Gets or sets the brokered message properties.
     */
    @JvmName("hlxhhskfnmqsvnrc")
    public suspend
    fun brokeredMessageProperties(`value`: Output<ServiceBusBrokeredMessagePropertiesArgs>) {
        this.brokeredMessageProperties = value
    }

    /**
     * @param value Gets or sets the custom message properties.
     */
    @JvmName("pqkkaqvpebspwmik")
    public suspend fun customMessageProperties(`value`: Output<Map<String, String>>) {
        this.customMessageProperties = value
    }

    /**
     * @param value Gets or sets the message.
     */
    @JvmName("bbbhivfqmhhmfexp")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Gets or sets the namespace.
     */
    @JvmName("ietohmxwfafqthwo")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Gets or sets the topic path.
     */
    @JvmName("hhnrmfftbivudrqu")
    public suspend fun topicPath(`value`: Output<String>) {
        this.topicPath = value
    }

    /**
     * @param value Gets or sets the transport type.
     */
    @JvmName("crtnauucfkpctddr")
    public suspend fun transportType(`value`: Output<ServiceBusTransportType>) {
        this.transportType = value
    }

    /**
     * @param value Gets or sets the Service Bus authentication.
     */
    @JvmName("xmdktuoybvlmopxl")
    public suspend fun authentication(`value`: ServiceBusAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument Gets or sets the Service Bus authentication.
     */
    @JvmName("tkycfccqoikymioj")
    public suspend
    fun authentication(argument: suspend ServiceBusAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceBusAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value Gets or sets the brokered message properties.
     */
    @JvmName("sqbwvhqropicgtfq")
    public suspend fun brokeredMessageProperties(`value`: ServiceBusBrokeredMessagePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokeredMessageProperties = mapped
    }

    /**
     * @param argument Gets or sets the brokered message properties.
     */
    @JvmName("mdphaxflibhuuwog")
    public suspend
    fun brokeredMessageProperties(argument: suspend ServiceBusBrokeredMessagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceBusBrokeredMessagePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.brokeredMessageProperties = mapped
    }

    /**
     * @param value Gets or sets the custom message properties.
     */
    @JvmName("hsetmphhwckgxmvd")
    public suspend fun customMessageProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customMessageProperties = mapped
    }

    /**
     * @param values Gets or sets the custom message properties.
     */
    @JvmName("drbcihxwtlqygren")
    public fun customMessageProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customMessageProperties = mapped
    }

    /**
     * @param value Gets or sets the message.
     */
    @JvmName("iptygamqhcdawrjg")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Gets or sets the namespace.
     */
    @JvmName("uvpwlcptbtrqtifa")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Gets or sets the topic path.
     */
    @JvmName("rikjdqqstnosaurp")
    public suspend fun topicPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicPath = mapped
    }

    /**
     * @param value Gets or sets the transport type.
     */
    @JvmName("kxxpmfktllasrqxx")
    public suspend fun transportType(`value`: ServiceBusTransportType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportType = mapped
    }

    internal fun build(): ServiceBusTopicMessageArgs = ServiceBusTopicMessageArgs(
        authentication = authentication,
        brokeredMessageProperties = brokeredMessageProperties,
        customMessageProperties = customMessageProperties,
        message = message,
        namespace = namespace,
        topicPath = topicPath,
        transportType = transportType,
    )
}
