@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property day Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
 * @property occurrence Gets or sets the occurrence. Must be between -5 and 5.
 */
public data class JobRecurrenceScheduleMonthlyOccurrenceResponse(
    public val day: String? = null,
    public val occurrence: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobRecurrenceScheduleMonthlyOccurrenceResponse):
            JobRecurrenceScheduleMonthlyOccurrenceResponse =
            JobRecurrenceScheduleMonthlyOccurrenceResponse(
                day = javaType.day().map({ args0 -> args0 }).orElse(null),
                occurrence = javaType.occurrence().map({ args0 -> args0 }).orElse(null),
            )
    }
}
