@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin

import com.pulumi.azurenative.scom.kotlin.outputs.MonitoredResourcePropertiesResponse
import com.pulumi.azurenative.scom.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.scom.kotlin.outputs.MonitoredResourcePropertiesResponse.Companion.toKotlin as monitoredResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.scom.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MonitoredResource].
 */
@PulumiTagMarker
public class MonitoredResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitoredResourceArgs = MonitoredResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitoredResourceArgsBuilder.() -> Unit) {
        val builder = MonitoredResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MonitoredResource {
        val builtJavaResource = com.pulumi.azurenative.scom.MonitoredResource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MonitoredResource(builtJavaResource)
    }
}

/**
 * A monitored resource.
 * Azure REST API version: 2023-07-07-preview.
 * ## Example Usage
 * ### MonitoredResources_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoredResource = new AzureNative.Scom.MonitoredResource("monitoredResource", new()
 *     {
 *         InstanceName = "myInstance",
 *         MonitoredResourceName = "d877b154-9a8d-4bfe-8a24-20682fcf2ed3",
 *         ResourceGroupName = "myResGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scom/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scom.NewMonitoredResource(ctx, "monitoredResource", &scom.MonitoredResourceArgs{
 * 			InstanceName:          pulumi.String("myInstance"),
 * 			MonitoredResourceName: pulumi.String("d877b154-9a8d-4bfe-8a24-20682fcf2ed3"),
 * 			ResourceGroupName:     pulumi.String("myResGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scom.MonitoredResource;
 * import com.pulumi.azurenative.scom.MonitoredResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoredResource = new MonitoredResource("monitoredResource", MonitoredResourceArgs.builder()
 *             .instanceName("myInstance")
 *             .monitoredResourceName("d877b154-9a8d-4bfe-8a24-20682fcf2ed3")
 *             .resourceGroupName("myResGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scom:MonitoredResource d877b154-9a8d-4bfe-8a24-20682fcf2ed3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scom/managedInstances/{instanceName}/monitoredResources/{monitoredResourceName}
 * ```
 */
public class MonitoredResource internal constructor(
    override val javaResource: com.pulumi.azurenative.scom.MonitoredResource,
) : KotlinCustomResource(javaResource, MonitoredResourceMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of a monitored resource.
     */
    public val properties: Output<MonitoredResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                monitoredResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MonitoredResourceMapper : ResourceMapper<MonitoredResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scom.MonitoredResource::class == javaResource::class

    override fun map(javaResource: Resource): MonitoredResource = MonitoredResource(
        javaResource as
            com.pulumi.azurenative.scom.MonitoredResource,
    )
}

/**
 * @see [MonitoredResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MonitoredResource].
 */
public suspend fun monitoredResource(
    name: String,
    block: suspend MonitoredResourceResourceBuilder.() -> Unit,
): MonitoredResource {
    val builder = MonitoredResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MonitoredResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitoredResource(name: String): MonitoredResource {
    val builder = MonitoredResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
