@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.inputs

import com.pulumi.azurenative.scom.inputs.AzureHybridBenefitPropertiesArgs.builder
import com.pulumi.azurenative.scom.kotlin.enums.HybridLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties to maximize savings by using Azure Hybrid Benefit
 * @property scomLicenseType SCOM license type. Maximize savings by using license you already own
 * @property sqlServerLicenseType SQL Server license type. Maximize savings by using Azure Hybrid Benefit for SQL Server with license you already own
 * @property windowsServerLicenseType Specifies that the image or disk that is being used was licensed on-premises. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
 */
public data class AzureHybridBenefitPropertiesArgs(
    public val scomLicenseType: Output<Either<String, HybridLicenseType>>? = null,
    public val sqlServerLicenseType: Output<Either<String, HybridLicenseType>>? = null,
    public val windowsServerLicenseType: Output<Either<String, HybridLicenseType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.inputs.AzureHybridBenefitPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.inputs.AzureHybridBenefitPropertiesArgs =
        com.pulumi.azurenative.scom.inputs.AzureHybridBenefitPropertiesArgs.builder()
            .scomLicenseType(
                scomLicenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sqlServerLicenseType(
                sqlServerLicenseType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .windowsServerLicenseType(
                windowsServerLicenseType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AzureHybridBenefitPropertiesArgs].
 */
@PulumiTagMarker
public class AzureHybridBenefitPropertiesArgsBuilder internal constructor() {
    private var scomLicenseType: Output<Either<String, HybridLicenseType>>? = null

    private var sqlServerLicenseType: Output<Either<String, HybridLicenseType>>? = null

    private var windowsServerLicenseType: Output<Either<String, HybridLicenseType>>? = null

    /**
     * @param value SCOM license type. Maximize savings by using license you already own
     */
    @JvmName("nmiviulukwgxadsq")
    public suspend fun scomLicenseType(`value`: Output<Either<String, HybridLicenseType>>) {
        this.scomLicenseType = value
    }

    /**
     * @param value SQL Server license type. Maximize savings by using Azure Hybrid Benefit for SQL Server with license you already own
     */
    @JvmName("sgmdvcyyssmkddno")
    public suspend fun sqlServerLicenseType(`value`: Output<Either<String, HybridLicenseType>>) {
        this.sqlServerLicenseType = value
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     */
    @JvmName("fofhpyeifwwloaqf")
    public suspend fun windowsServerLicenseType(`value`: Output<Either<String, HybridLicenseType>>) {
        this.windowsServerLicenseType = value
    }

    /**
     * @param value SCOM license type. Maximize savings by using license you already own
     */
    @JvmName("bovawmfpunkbydcw")
    public suspend fun scomLicenseType(`value`: Either<String, HybridLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scomLicenseType = mapped
    }

    /**
     * @param value SCOM license type. Maximize savings by using license you already own
     */
    @JvmName("hbcitrcgkcmjmnol")
    public fun scomLicenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HybridLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scomLicenseType = mapped
    }

    /**
     * @param value SCOM license type. Maximize savings by using license you already own
     */
    @JvmName("wtqlcjuhaquoohkj")
    public fun scomLicenseType(`value`: HybridLicenseType) {
        val toBeMapped = Either.ofRight<String, HybridLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scomLicenseType = mapped
    }

    /**
     * @param value SQL Server license type. Maximize savings by using Azure Hybrid Benefit for SQL Server with license you already own
     */
    @JvmName("pkklanlhfyvpvscq")
    public suspend fun sqlServerLicenseType(`value`: Either<String, HybridLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value SQL Server license type. Maximize savings by using Azure Hybrid Benefit for SQL Server with license you already own
     */
    @JvmName("jjqhshgywptkidkl")
    public fun sqlServerLicenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HybridLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value SQL Server license type. Maximize savings by using Azure Hybrid Benefit for SQL Server with license you already own
     */
    @JvmName("byrhuvigqmhejwmn")
    public fun sqlServerLicenseType(`value`: HybridLicenseType) {
        val toBeMapped = Either.ofRight<String, HybridLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     */
    @JvmName("oaigwrrksutsstbs")
    public suspend fun windowsServerLicenseType(`value`: Either<String, HybridLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsServerLicenseType = mapped
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     */
    @JvmName("eoahuvyvnhgwqomy")
    public fun windowsServerLicenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HybridLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsServerLicenseType = mapped
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
     */
    @JvmName("fohepqsehmnkowfp")
    public fun windowsServerLicenseType(`value`: HybridLicenseType) {
        val toBeMapped = Either.ofRight<String, HybridLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.windowsServerLicenseType = mapped
    }

    internal fun build(): AzureHybridBenefitPropertiesArgs = AzureHybridBenefitPropertiesArgs(
        scomLicenseType = scomLicenseType,
        sqlServerLicenseType = sqlServerLicenseType,
        windowsServerLicenseType = windowsServerLicenseType,
    )
}
