@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.inputs

import com.pulumi.azurenative.scom.inputs.GetMonitoredResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceName Name of the SCOM managed instance.
 * @property monitoredResourceName The monitored resource name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMonitoredResourcePlainArgs(
    public val instanceName: String,
    public val monitoredResourceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scom.inputs.GetMonitoredResourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.inputs.GetMonitoredResourcePlainArgs =
        com.pulumi.azurenative.scom.inputs.GetMonitoredResourcePlainArgs.builder()
            .instanceName(instanceName.let({ args0 -> args0 }))
            .monitoredResourceName(monitoredResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMonitoredResourcePlainArgs].
 */
@PulumiTagMarker
public class GetMonitoredResourcePlainArgsBuilder internal constructor() {
    private var instanceName: String? = null

    private var monitoredResourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the SCOM managed instance.
     */
    @JvmName("slojmgubvdajxtea")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value The monitored resource name.
     */
    @JvmName("ndqtcastwthqmpsh")
    public suspend fun monitoredResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitoredResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hyyogdkalcenhvuu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMonitoredResourcePlainArgs = GetMonitoredResourcePlainArgs(
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        monitoredResourceName = monitoredResourceName ?: throw
            PulumiNullFieldException("monitoredResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
