@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Get Domain user name and password from key vault
 * @property keyVaultUrl Key vault url to get the domain username and password
 * @property passwordSecret Domain Password secret
 * @property userNameSecret Domain user name secret
 */
public data class DomainUserCredentialsResponse(
    public val keyVaultUrl: String? = null,
    public val passwordSecret: String? = null,
    public val userNameSecret: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.DomainUserCredentialsResponse):
            DomainUserCredentialsResponse = DomainUserCredentialsResponse(
            keyVaultUrl = javaType.keyVaultUrl().map({ args0 -> args0 }).orElse(null),
            passwordSecret = javaType.passwordSecret().map({ args0 -> args0 }).orElse(null),
            userNameSecret = javaType.userNameSecret().map({ args0 -> args0 }).orElse(null),
        )
    }
}
