@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.AvailabilitySetArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The AvailabilitySets resource definition.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateAvailabilitySet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var availabilitySet = new AzureNative.ScVmm.AvailabilitySet("availabilitySet", new()
 *     {
 *         AvailabilitySetName = "hr-avset",
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "testrg",
 *         VmmServerId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ScVmm/VMMServers/ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewAvailabilitySet(ctx, "availabilitySet", &scvmm.AvailabilitySetArgs{
 * 			AvailabilitySetName: pulumi.String("hr-avset"),
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			VmmServerId:       pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ScVmm/VMMServers/ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.AvailabilitySet;
 * import com.pulumi.azurenative.scvmm.AvailabilitySetArgs;
 * import com.pulumi.azurenative.scvmm.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var availabilitySet = new AvailabilitySet("availabilitySet", AvailabilitySetArgs.builder()
 *             .availabilitySetName("hr-avset")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("testrg")
 *             .vmmServerId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ScVmm/VMMServers/ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:AvailabilitySet HRAvailabilitySet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/availabilitySets/{availabilitySetName}
 * ```
 * @property availabilitySetName Name of the availability set.
 * @property extendedLocation The extended location.
 * @property location Gets or sets the location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class AvailabilitySetArgs(
    public val availabilitySetName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vmmServerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.AvailabilitySetArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.AvailabilitySetArgs =
        com.pulumi.azurenative.scvmm.AvailabilitySetArgs.builder()
            .availabilitySetName(availabilitySetName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vmmServerId(vmmServerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvailabilitySetArgs].
 */
@PulumiTagMarker
public class AvailabilitySetArgsBuilder internal constructor() {
    private var availabilitySetName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vmmServerId: Output<String>? = null

    /**
     * @param value Name of the availability set.
     */
    @JvmName("cutdmnjactlbhlil")
    public suspend fun availabilitySetName(`value`: Output<String>) {
        this.availabilitySetName = value
    }

    /**
     * @param value The extended location.
     */
    @JvmName("lyagjlxxfpvhqwhv")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("kdrcrycrejkhdrmv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cpcknsgtjvqonoqd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("lvgpvljmvgdgvbur")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARM Id of the vmmServer resource in which this resource resides.
     */
    @JvmName("sdhcjtscimheqxns")
    public suspend fun vmmServerId(`value`: Output<String>) {
        this.vmmServerId = value
    }

    /**
     * @param value Name of the availability set.
     */
    @JvmName("wlsegrtbalrwaons")
    public suspend fun availabilitySetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySetName = mapped
    }

    /**
     * @param value The extended location.
     */
    @JvmName("julclnjvxvcigpit")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location.
     */
    @JvmName("qlytaoglghtdetfw")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("oraukpnupdrlxtll")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qbmsonneprdomiwj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("axrjvqirrfwqafqw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("qyffcckxduxediog")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ARM Id of the vmmServer resource in which this resource resides.
     */
    @JvmName("magftcdtcsbeuexy")
    public suspend fun vmmServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmmServerId = mapped
    }

    internal fun build(): AvailabilitySetArgs = AvailabilitySetArgs(
        availabilitySetName = availabilitySetName,
        extendedLocation = extendedLocation,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vmmServerId = vmmServerId,
    )
}
