@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.CloudCapacityResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.StorageQoSPolicyResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.scvmm.kotlin.outputs.CloudCapacityResponse.Companion.toKotlin as cloudCapacityResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.StorageQoSPolicyResponse.Companion.toKotlin as storageQoSPolicyResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Cloud].
 */
@PulumiTagMarker
public class CloudResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudArgs = CloudArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudArgsBuilder.() -> Unit) {
        val builder = CloudArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cloud {
        val builtJavaResource = com.pulumi.azurenative.scvmm.Cloud(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cloud(builtJavaResource)
    }
}

/**
 * The Clouds resource definition.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateCloud
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloud = new AzureNative.ScVmm.Cloud("cloud", new()
 *     {
 *         CloudName = "HRCloud",
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "testrg",
 *         Uuid = "aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
 *         VmmServerId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewCloud(ctx, "cloud", &scvmm.CloudArgs{
 * 			CloudName: pulumi.String("HRCloud"),
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Uuid:              pulumi.String("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
 * 			VmmServerId:       pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.Cloud;
 * import com.pulumi.azurenative.scvmm.CloudArgs;
 * import com.pulumi.azurenative.scvmm.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloud = new Cloud("cloud", CloudArgs.builder()
 *             .cloudName("HRCloud")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("testrg")
 *             .uuid("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee")
 *             .vmmServerId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:Cloud HRCloud /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/clouds/{cloudName}
 * ```
 */
public class Cloud internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.Cloud,
) : KotlinCustomResource(javaResource, CloudMapper) {
    /**
     * Capacity of the cloud.
     */
    public val cloudCapacity: Output<CloudCapacityResponse>
        get() = javaResource.cloudCapacity().applyValue({ args0 ->
            args0.let({ args0 ->
                cloudCapacityResponseToKotlin(args0)
            })
        })

    /**
     * Name of the cloud in VMMServer.
     */
    public val cloudName: Output<String>
        get() = javaResource.cloudName().applyValue({ args0 -> args0 })

    /**
     * The extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the inventory Item ID for the resource.
     */
    public val inventoryItemId: Output<String>?
        get() = javaResource.inventoryItemId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of QoS policies available for the cloud.
     */
    public val storageQoSPolicies: Output<List<StorageQoSPolicyResponse>>
        get() = javaResource.storageQoSPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageQoSPolicyResponseToKotlin(args0) })
            })
        })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique ID of the cloud.
     */
    public val uuid: Output<String>?
        get() = javaResource.uuid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARM Id of the vmmServer resource in which this resource resides.
     */
    public val vmmServerId: Output<String>?
        get() = javaResource.vmmServerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object CloudMapper : ResourceMapper<Cloud> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.Cloud::class == javaResource::class

    override fun map(javaResource: Resource): Cloud = Cloud(
        javaResource as
            com.pulumi.azurenative.scvmm.Cloud,
    )
}

/**
 * @see [Cloud].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cloud].
 */
public suspend fun cloud(name: String, block: suspend CloudResourceBuilder.() -> Unit): Cloud {
    val builder = CloudResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cloud].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloud(name: String): Cloud {
    val builder = CloudResourceBuilder()
    builder.name(name)
    return builder.build()
}
