@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.InventoryItemArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.enums.InventoryType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the inventory item.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateInventoryItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var inventoryItem = new AzureNative.ScVmm.InventoryItem("inventoryItem", new()
 *     {
 *         InventoryItemName = "12345678-1234-1234-1234-123456789abc",
 *         InventoryType = AzureNative.ScVmm.InventoryType.Cloud,
 *         ResourceGroupName = "testrg",
 *         VmmServerName = "ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewInventoryItem(ctx, "inventoryItem", &scvmm.InventoryItemArgs{
 * 			InventoryItemName: pulumi.String("12345678-1234-1234-1234-123456789abc"),
 * 			InventoryType:     pulumi.String(scvmm.InventoryTypeCloud),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			VmmServerName:     pulumi.String("ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.InventoryItem;
 * import com.pulumi.azurenative.scvmm.InventoryItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var inventoryItem = new InventoryItem("inventoryItem", InventoryItemArgs.builder()
 *             .inventoryItemName("12345678-1234-1234-1234-123456789abc")
 *             .inventoryType("Cloud")
 *             .resourceGroupName("testrg")
 *             .vmmServerName("ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:InventoryItem 12345678-1234-1234-1234-123456789abc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}/inventoryItems/{inventoryItemName}
 * ```
 * @property inventoryItemName Name of the inventoryItem.
 * @property inventoryType They inventory type.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property resourceGroupName The name of the resource group.
 * @property vmmServerName Name of the VMMServer.
 */
public data class InventoryItemArgs(
    public val inventoryItemName: Output<String>? = null,
    public val inventoryType: Output<Either<String, InventoryType>>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vmmServerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.InventoryItemArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.InventoryItemArgs =
        com.pulumi.azurenative.scvmm.InventoryItemArgs.builder()
            .inventoryItemName(inventoryItemName?.applyValue({ args0 -> args0 }))
            .inventoryType(
                inventoryType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vmmServerName(vmmServerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InventoryItemArgs].
 */
@PulumiTagMarker
public class InventoryItemArgsBuilder internal constructor() {
    private var inventoryItemName: Output<String>? = null

    private var inventoryType: Output<Either<String, InventoryType>>? = null

    private var kind: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var vmmServerName: Output<String>? = null

    /**
     * @param value Name of the inventoryItem.
     */
    @JvmName("afpqdcpkrgqdgojh")
    public suspend fun inventoryItemName(`value`: Output<String>) {
        this.inventoryItemName = value
    }

    /**
     * @param value They inventory type.
     */
    @JvmName("pmctougbhrpndwvm")
    public suspend fun inventoryType(`value`: Output<Either<String, InventoryType>>) {
        this.inventoryType = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("ccgnkbfsindowupe")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ebkuytjjjkbkelto")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the VMMServer.
     */
    @JvmName("hmlnvuhfsnvsxksf")
    public suspend fun vmmServerName(`value`: Output<String>) {
        this.vmmServerName = value
    }

    /**
     * @param value Name of the inventoryItem.
     */
    @JvmName("okqthvtthidnepsq")
    public suspend fun inventoryItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemName = mapped
    }

    /**
     * @param value They inventory type.
     */
    @JvmName("koyrcjtohjbubeyq")
    public suspend fun inventoryType(`value`: Either<String, InventoryType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryType = mapped
    }

    /**
     * @param value They inventory type.
     */
    @JvmName("gxuekcvlockwdcqe")
    public fun inventoryType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InventoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inventoryType = mapped
    }

    /**
     * @param value They inventory type.
     */
    @JvmName("dtopqymgpxqadkpl")
    public fun inventoryType(`value`: InventoryType) {
        val toBeMapped = Either.ofRight<String, InventoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inventoryType = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("chttepicypktftsl")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fjaefjvvncqylwhk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the VMMServer.
     */
    @JvmName("yhadqkerpnipsdrr")
    public suspend fun vmmServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmmServerName = mapped
    }

    internal fun build(): InventoryItemArgs = InventoryItemArgs(
        inventoryItemName = inventoryItemName,
        inventoryType = inventoryType,
        kind = kind,
        resourceGroupName = resourceGroupName,
        vmmServerName = vmmServerName,
    )
}
