@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.CheckpointResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.GuestAgentProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.HardwareProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.OsProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.StorageProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualMachinePropertiesResponseAvailabilitySets
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.scvmm.kotlin.outputs.CheckpointResponse.Companion.toKotlin as checkpointResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.GuestAgentProfileResponse.Companion.toKotlin as guestAgentProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin as hardwareProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.OsProfileResponse.Companion.toKotlin as osProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.StorageProfileResponse.Companion.toKotlin as storageProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualMachinePropertiesResponseAvailabilitySets.Companion.toKotlin as virtualMachinePropertiesResponseAvailabilitySetsToKotlin

/**
 * Builder for [VirtualMachine].
 */
@PulumiTagMarker
public class VirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineArgs = VirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineArgsBuilder.() -> Unit) {
        val builder = VirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachine {
        val builtJavaResource = com.pulumi.azurenative.scvmm.VirtualMachine(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualMachine(builtJavaResource)
    }
}

/**
 * The VirtualMachines resource definition.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.ScVmm.VirtualMachine("virtualMachine", new()
 *     {
 *         CloudId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud",
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         HardwareProfile = new AzureNative.ScVmm.Inputs.HardwareProfileArgs
 *         {
 *             CpuCount = 4,
 *             MemoryMB = 4096,
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "testrg",
 *         TemplateId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate",
 *         VirtualMachineName = "DemoVM",
 *         VmmServerId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVirtualMachine(ctx, "virtualMachine", &scvmm.VirtualMachineArgs{
 * 			CloudId: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			HardwareProfile: &scvmm.HardwareProfileArgs{
 * 				CpuCount: pulumi.Int(4),
 * 				MemoryMB: pulumi.Int(4096),
 * 			},
 * 			Location:           pulumi.String("East US"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			TemplateId:         pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
 * 			VirtualMachineName: pulumi.String("DemoVM"),
 * 			VmmServerId:        pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VirtualMachine;
 * import com.pulumi.azurenative.scvmm.VirtualMachineArgs;
 * import com.pulumi.azurenative.scvmm.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.scvmm.inputs.HardwareProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .cloudId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .cpuCount(4)
 *                 .memoryMB(4096)
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("testrg")
 *             .templateId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate")
 *             .virtualMachineName("DemoVM")
 *             .vmmServerId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VirtualMachine DemoVM /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/virtualMachines/{virtualMachineName}
 * ```
 */
public class VirtualMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.VirtualMachine,
) : KotlinCustomResource(javaResource, VirtualMachineMapper) {
    /**
     * Availability Sets in vm.
     */
    public val availabilitySets: Output<List<VirtualMachinePropertiesResponseAvailabilitySets>>?
        get() = javaResource.availabilitySets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        virtualMachinePropertiesResponseAvailabilitySetsToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Type of checkpoint supported for the vm.
     */
    public val checkpointType: Output<String>?
        get() = javaResource.checkpointType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Checkpoints in the vm.
     */
    public val checkpoints: Output<List<CheckpointResponse>>?
        get() = javaResource.checkpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> checkpointResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * ARM Id of the cloud resource to use for deploying the vm.
     */
    public val cloudId: Output<String>?
        get() = javaResource.cloudId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the generation for the vm.
     */
    public val generation: Output<Int>?
        get() = javaResource.generation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Guest agent status properties.
     */
    public val guestAgentProfile: Output<GuestAgentProfileResponse>?
        get() = javaResource.guestAgentProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> guestAgentProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Hardware properties.
     */
    public val hardwareProfile: Output<HardwareProfileResponse>?
        get() = javaResource.hardwareProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hardwareProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the inventory Item ID for the resource.
     */
    public val inventoryItemId: Output<String>?
        get() = javaResource.inventoryItemId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last restored checkpoint in the vm.
     */
    public val lastRestoredVMCheckpoint: Output<CheckpointResponse>
        get() = javaResource.lastRestoredVMCheckpoint().applyValue({ args0 ->
            args0.let({ args0 ->
                checkpointResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network properties.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * OS properties.
     */
    public val osProfile: Output<OsProfileResponse>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    osProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets the power state of the virtual machine.
     */
    public val powerState: Output<String>
        get() = javaResource.powerState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Storage properties.
     */
    public val storageProfile: Output<StorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * ARM Id of the template resource to use for deploying the vm.
     */
    public val templateId: Output<String>?
        get() = javaResource.templateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique ID of the virtual machine.
     */
    public val uuid: Output<String>?
        get() = javaResource.uuid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * VMName is the name of VM on the SCVMM server.
     */
    public val vmName: Output<String>?
        get() = javaResource.vmName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARM Id of the vmmServer resource in which this resource resides.
     */
    public val vmmServerId: Output<String>?
        get() = javaResource.vmmServerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VirtualMachineMapper : ResourceMapper<VirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.VirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachine = VirtualMachine(
        javaResource as
            com.pulumi.azurenative.scvmm.VirtualMachine,
    )
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachine].
 */
public suspend fun virtualMachine(
    name: String,
    block: suspend VirtualMachineResourceBuilder.() -> Unit,
): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachine(name: String): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
