@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.HardwareProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.InfrastructureProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.OsProfileForVMInstanceResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.StorageProfileResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualMachineInstancePropertiesResponseAvailabilitySets
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin as hardwareProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.InfrastructureProfileResponse.Companion.toKotlin as infrastructureProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.OsProfileForVMInstanceResponse.Companion.toKotlin as osProfileForVMInstanceResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.StorageProfileResponse.Companion.toKotlin as storageProfileResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualMachineInstancePropertiesResponseAvailabilitySets.Companion.toKotlin as virtualMachineInstancePropertiesResponseAvailabilitySetsToKotlin

/**
 * Builder for [VirtualMachineInstance].
 */
@PulumiTagMarker
public class VirtualMachineInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineInstanceArgs = VirtualMachineInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineInstanceArgsBuilder.() -> Unit) {
        val builder = VirtualMachineInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineInstance {
        val builtJavaResource =
            com.pulumi.azurenative.scvmm.VirtualMachineInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineInstance(builtJavaResource)
    }
}

/**
 * Define the virtualMachineInstance.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-10-07.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.ScVmm.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         HardwareProfile = new AzureNative.ScVmm.Inputs.HardwareProfileArgs
 *         {
 *             CpuCount = 4,
 *             MemoryMB = 4196,
 *         },
 *         InfrastructureProfile = new AzureNative.ScVmm.Inputs.InfrastructureProfileArgs
 *         {
 *             CloudId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud",
 *             TemplateId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate",
 *             VmmServerId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer",
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &scvmm.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			HardwareProfile: &scvmm.HardwareProfileArgs{
 * 				CpuCount: pulumi.Int(4),
 * 				MemoryMB: pulumi.Int(4196),
 * 			},
 * 			InfrastructureProfile: &scvmm.InfrastructureProfileArgs{
 * 				CloudId:     pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
 * 				TemplateId:  pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
 * 				VmmServerId: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VirtualMachineInstance;
 * import com.pulumi.azurenative.scvmm.VirtualMachineInstanceArgs;
 * import com.pulumi.azurenative.scvmm.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.scvmm.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.scvmm.inputs.InfrastructureProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .cpuCount(4)
 *                 .memoryMB(4196)
 *                 .build())
 *             .infrastructureProfile(InfrastructureProfileArgs.builder()
 *                 .cloudId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud")
 *                 .templateId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate")
 *                 .vmmServerId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer")
 *                 .build())
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VirtualMachineInstance default /{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default
 * ```
 */
public class VirtualMachineInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.VirtualMachineInstance,
) : KotlinCustomResource(javaResource, VirtualMachineInstanceMapper) {
    /**
     * Availability Sets in vm.
     */
    public val availabilitySets:
        Output<List<VirtualMachineInstancePropertiesResponseAvailabilitySets>>?
        get() = javaResource.availabilitySets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        virtualMachineInstancePropertiesResponseAvailabilitySetsToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Hardware properties.
     */
    public val hardwareProfile: Output<HardwareProfileResponse>?
        get() = javaResource.hardwareProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hardwareProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the infrastructure profile.
     */
    public val infrastructureProfile: Output<InfrastructureProfileResponse>?
        get() = javaResource.infrastructureProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> infrastructureProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network properties.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * OS properties.
     */
    public val osProfile: Output<OsProfileForVMInstanceResponse>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    osProfileForVMInstanceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets the power state of the virtual machine.
     */
    public val powerState: Output<String>
        get() = javaResource.powerState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Storage properties.
     */
    public val storageProfile: Output<StorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualMachineInstanceMapper : ResourceMapper<VirtualMachineInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.VirtualMachineInstance::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineInstance =
        VirtualMachineInstance(javaResource as com.pulumi.azurenative.scvmm.VirtualMachineInstance)
}

/**
 * @see [VirtualMachineInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineInstance].
 */
public suspend fun virtualMachineInstance(
    name: String,
    block: suspend VirtualMachineInstanceResourceBuilder.() -> Unit,
): VirtualMachineInstance {
    val builder = VirtualMachineInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineInstance(name: String): VirtualMachineInstance {
    val builder = VirtualMachineInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
