@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkInterfacesResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualDiskResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkInterfacesResponse.Companion.toKotlin as networkInterfacesResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualDiskResponse.Companion.toKotlin as virtualDiskResponseToKotlin

/**
 * Builder for [VirtualMachineTemplate].
 */
@PulumiTagMarker
public class VirtualMachineTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineTemplateArgs = VirtualMachineTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineTemplateArgsBuilder.() -> Unit) {
        val builder = VirtualMachineTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineTemplate {
        val builtJavaResource =
            com.pulumi.azurenative.scvmm.VirtualMachineTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineTemplate(builtJavaResource)
    }
}

/**
 * The VirtualMachineTemplates resource definition.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateVirtualMachineTemplate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineTemplate = new AzureNative.ScVmm.VirtualMachineTemplate("virtualMachineTemplate", new()
 *     {
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "testrg",
 *         Uuid = "aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
 *         VirtualMachineTemplateName = "HRVirtualMachineTemplate",
 *         VmmServerId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVirtualMachineTemplate(ctx, "virtualMachineTemplate", &scvmm.VirtualMachineTemplateArgs{
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Location:                   pulumi.String("East US"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			Uuid:                       pulumi.String("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
 * 			VirtualMachineTemplateName: pulumi.String("HRVirtualMachineTemplate"),
 * 			VmmServerId:                pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VirtualMachineTemplate;
 * import com.pulumi.azurenative.scvmm.VirtualMachineTemplateArgs;
 * import com.pulumi.azurenative.scvmm.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineTemplate = new VirtualMachineTemplate("virtualMachineTemplate", VirtualMachineTemplateArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("testrg")
 *             .uuid("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee")
 *             .virtualMachineTemplateName("HRVirtualMachineTemplate")
 *             .vmmServerId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VirtualMachineTemplate HRVirtualMachineTemplate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/virtualMachineTemplates/{virtualMachineTemplateName}
 * ```
 */
public class VirtualMachineTemplate internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.VirtualMachineTemplate,
) : KotlinCustomResource(javaResource, VirtualMachineTemplateMapper) {
    /**
     * Gets or sets computer name.
     */
    public val computerName: Output<String>
        get() = javaResource.computerName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the desired number of vCPUs for the vm.
     */
    public val cpuCount: Output<Int>
        get() = javaResource.cpuCount().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the disks of the template.
     */
    public val disks: Output<List<VirtualDiskResponse>>
        get() = javaResource.disks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualDiskResponseToKotlin(args0)
                })
            })
        })

    /**
     * Gets or sets a value indicating whether to enable dynamic memory or not.
     */
    public val dynamicMemoryEnabled: Output<String>
        get() = javaResource.dynamicMemoryEnabled().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the max dynamic memory for the vm.
     */
    public val dynamicMemoryMaxMB: Output<Int>
        get() = javaResource.dynamicMemoryMaxMB().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the min dynamic memory for the vm.
     */
    public val dynamicMemoryMinMB: Output<Int>
        get() = javaResource.dynamicMemoryMinMB().applyValue({ args0 -> args0 })

    /**
     * The extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the generation for the vm.
     */
    public val generation: Output<Int>
        get() = javaResource.generation().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the inventory Item ID for the resource.
     */
    public val inventoryItemId: Output<String>?
        get() = javaResource.inventoryItemId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a value indicating whether the vm template is customizable or not.
     */
    public val isCustomizable: Output<String>
        get() = javaResource.isCustomizable().applyValue({ args0 -> args0 })

    /**
     * Gets highly available property.
     */
    public val isHighlyAvailable: Output<String>
        get() = javaResource.isHighlyAvailable().applyValue({ args0 -> args0 })

    /**
     * Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
     */
    public val limitCpuForMigration: Output<String>
        get() = javaResource.limitCpuForMigration().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * MemoryMB is the desired size of a virtual machine's memory, in MB.
     */
    public val memoryMB: Output<Int>
        get() = javaResource.memoryMB().applyValue({ args0 -> args0 })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the network interfaces of the template.
     */
    public val networkInterfaces: Output<List<NetworkInterfacesResponse>>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfacesResponseToKotlin(args0) })
            })
        })

    /**
     * Gets or sets os name.
     */
    public val osName: Output<String>
        get() = javaResource.osName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the type of the os.
     */
    public val osType: Output<String>
        get() = javaResource.osType().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique ID of the virtual machine template.
     */
    public val uuid: Output<String>?
        get() = javaResource.uuid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARM Id of the vmmServer resource in which this resource resides.
     */
    public val vmmServerId: Output<String>?
        get() = javaResource.vmmServerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VirtualMachineTemplateMapper : ResourceMapper<VirtualMachineTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.VirtualMachineTemplate::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineTemplate =
        VirtualMachineTemplate(javaResource as com.pulumi.azurenative.scvmm.VirtualMachineTemplate)
}

/**
 * @see [VirtualMachineTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineTemplate].
 */
public suspend fun virtualMachineTemplate(
    name: String,
    block: suspend VirtualMachineTemplateResourceBuilder.() -> Unit,
): VirtualMachineTemplate {
    val builder = VirtualMachineTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineTemplate(name: String): VirtualMachineTemplate {
    val builder = VirtualMachineTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
