@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.VmmServerArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.VMMServerPropertiesCredentialsArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.VMMServerPropertiesCredentialsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The VmmServers resource definition.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateVMMServer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vmmServer = new AzureNative.ScVmm.VmmServer("vmmServer", new()
 *     {
 *         Credentials = new AzureNative.ScVmm.Inputs.VMMServerPropertiesCredentialsArgs
 *         {
 *             Password = "password",
 *             Username = "testuser",
 *         },
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Fqdn = "VMM.contoso.com",
 *         Location = "East US",
 *         Port = 1234,
 *         ResourceGroupName = "testrg",
 *         VmmServerName = "ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVmmServer(ctx, "vmmServer", &scvmm.VmmServerArgs{
 * 			Credentials: &scvmm.VMMServerPropertiesCredentialsArgs{
 * 				Password: pulumi.String("password"),
 * 				Username: pulumi.String("testuser"),
 * 			},
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Fqdn:              pulumi.String("VMM.contoso.com"),
 * 			Location:          pulumi.String("East US"),
 * 			Port:              pulumi.Int(1234),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			VmmServerName:     pulumi.String("ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VmmServer;
 * import com.pulumi.azurenative.scvmm.VmmServerArgs;
 * import com.pulumi.azurenative.scvmm.inputs.VMMServerPropertiesCredentialsArgs;
 * import com.pulumi.azurenative.scvmm.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vmmServer = new VmmServer("vmmServer", VmmServerArgs.builder()
 *             .credentials(VMMServerPropertiesCredentialsArgs.builder()
 *                 .password("password")
 *                 .username("testuser")
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .fqdn("VMM.contoso.com")
 *             .location("East US")
 *             .port(1234)
 *             .resourceGroupName("testrg")
 *             .vmmServerName("ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VmmServer ContosoVMMServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}
 * ```
 * @property credentials Credentials to connect to VMMServer.
 * @property extendedLocation The extended location.
 * @property fqdn Fqdn is the hostname/ip of the vmmServer.
 * @property location Gets or sets the location.
 * @property port Port is the port on which the vmmServer is listening.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags
 * @property vmmServerName Name of the VMMServer.
 */
public data class VmmServerArgs(
    public val credentials: Output<VMMServerPropertiesCredentialsArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val fqdn: Output<String>? = null,
    public val location: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vmmServerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.VmmServerArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.VmmServerArgs =
        com.pulumi.azurenative.scvmm.VmmServerArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vmmServerName(vmmServerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VmmServerArgs].
 */
@PulumiTagMarker
public class VmmServerArgsBuilder internal constructor() {
    private var credentials: Output<VMMServerPropertiesCredentialsArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var fqdn: Output<String>? = null

    private var location: Output<String>? = null

    private var port: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vmmServerName: Output<String>? = null

    /**
     * @param value Credentials to connect to VMMServer.
     */
    @JvmName("elekbloaasdnkynd")
    public suspend fun credentials(`value`: Output<VMMServerPropertiesCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The extended location.
     */
    @JvmName("nngwahcuanrjyhax")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Fqdn is the hostname/ip of the vmmServer.
     */
    @JvmName("fxwfughgafpcdsas")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("viuveyijkwgslbtr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Port is the port on which the vmmServer is listening.
     */
    @JvmName("scghfvqgbuhkaifw")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lsvcwkrqcshycbme")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ttwrcsmtccehfxsi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the VMMServer.
     */
    @JvmName("uprkramhbvhvhcxo")
    public suspend fun vmmServerName(`value`: Output<String>) {
        this.vmmServerName = value
    }

    /**
     * @param value Credentials to connect to VMMServer.
     */
    @JvmName("ujpsyuufwvkyigvm")
    public suspend fun credentials(`value`: VMMServerPropertiesCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Credentials to connect to VMMServer.
     */
    @JvmName("qbxdftgknaryinut")
    public suspend
    fun credentials(argument: suspend VMMServerPropertiesCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = VMMServerPropertiesCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The extended location.
     */
    @JvmName("xttmridnbveoganx")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location.
     */
    @JvmName("fcxsvdqbicuthrvo")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Fqdn is the hostname/ip of the vmmServer.
     */
    @JvmName("ukvsevxyfgijngwh")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("pkejbvtxaspdjbcj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Port is the port on which the vmmServer is listening.
     */
    @JvmName("cpqejpmxrqpgmnqm")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hulrehpxtugsfeaj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qkfbhucyyeuncqsf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("dfjywafgppveufbc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the VMMServer.
     */
    @JvmName("nwenjxlorbukenka")
    public suspend fun vmmServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmmServerName = mapped
    }

    internal fun build(): VmmServerArgs = VmmServerArgs(
        credentials = credentials,
        extendedLocation = extendedLocation,
        fqdn = fqdn,
        location = location,
        port = port,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vmmServerName = vmmServerName,
    )
}
