@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetGuestAgentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property guestAgentName Name of the GuestAgent.
 * @property resourceGroupName The name of the resource group.
 * @property virtualMachineName Name of the vm.
 */
public data class GetGuestAgentPlainArgs(
    public val guestAgentName: String,
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetGuestAgentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetGuestAgentPlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetGuestAgentPlainArgs.builder()
            .guestAgentName(guestAgentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGuestAgentPlainArgs].
 */
@PulumiTagMarker
public class GetGuestAgentPlainArgsBuilder internal constructor() {
    private var guestAgentName: String? = null

    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value Name of the GuestAgent.
     */
    @JvmName("lgcwsrmoiekwpwps")
    public suspend fun guestAgentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.guestAgentName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nermaeeivbkcjffi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("ufgmksahwsxtvlga")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetGuestAgentPlainArgs = GetGuestAgentPlainArgs(
        guestAgentName = guestAgentName ?: throw PulumiNullFieldException("guestAgentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
