@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetVirtualMachineTemplatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property virtualMachineTemplateName Name of the VirtualMachineTemplate.
 */
public data class GetVirtualMachineTemplatePlainArgs(
    public val resourceGroupName: String,
    public val virtualMachineTemplateName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetVirtualMachineTemplatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetVirtualMachineTemplatePlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetVirtualMachineTemplatePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineTemplateName(virtualMachineTemplateName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineTemplatePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineTemplatePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualMachineTemplateName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vgnbirnngjouptmv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the VirtualMachineTemplate.
     */
    @JvmName("vylqiiqcoaanvgft")
    public suspend fun virtualMachineTemplateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineTemplateName = mapped
    }

    internal fun build(): GetVirtualMachineTemplatePlainArgs = GetVirtualMachineTemplatePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineTemplateName = virtualMachineTemplateName ?: throw
            PulumiNullFieldException("virtualMachineTemplateName"),
    )
}
