@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GuestCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Username / Password Credentials to connect to guest.
 * @property password Gets or sets the password to connect with the guest.
 * @property username Gets or sets username to connect with the guest.
 */
public data class GuestCredentialArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GuestCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GuestCredentialArgs =
        com.pulumi.azurenative.scvmm.inputs.GuestCredentialArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestCredentialArgs].
 */
@PulumiTagMarker
public class GuestCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Gets or sets the password to connect with the guest.
     */
    @JvmName("yldwkggcvredymtx")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Gets or sets username to connect with the guest.
     */
    @JvmName("qkowwmdugrbswipf")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Gets or sets the password to connect with the guest.
     */
    @JvmName("rqesxfyyrwhfklmt")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Gets or sets username to connect with the guest.
     */
    @JvmName("slgcjbgpmcefyaee")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): GuestCredentialArgs = GuestCredentialArgs(
        password = password,
        username = username,
    )
}
