@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.OsProfileForVMInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the resource properties.
 * @property adminPassword Admin password of the virtual machine.
 * @property computerName Gets or sets computer name.
 */
public data class OsProfileForVMInstanceArgs(
    public val adminPassword: Output<String>? = null,
    public val computerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.OsProfileForVMInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.OsProfileForVMInstanceArgs =
        com.pulumi.azurenative.scvmm.inputs.OsProfileForVMInstanceArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .computerName(computerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OsProfileForVMInstanceArgs].
 */
@PulumiTagMarker
public class OsProfileForVMInstanceArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var computerName: Output<String>? = null

    /**
     * @param value Admin password of the virtual machine.
     */
    @JvmName("icfsclvgmfpcmenq")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value Gets or sets computer name.
     */
    @JvmName("vmnocfvrecjtgtei")
    public suspend fun computerName(`value`: Output<String>) {
        this.computerName = value
    }

    /**
     * @param value Admin password of the virtual machine.
     */
    @JvmName("fslcxonhpxxlbvnk")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value Gets or sets computer name.
     */
    @JvmName("bcwacpjuothjuxex")
    public suspend fun computerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computerName = mapped
    }

    internal fun build(): OsProfileForVMInstanceArgs = OsProfileForVMInstanceArgs(
        adminPassword = adminPassword,
        computerName = computerName,
    )
}
