@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.VirtualDiskArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.enums.CreateDiffDisk
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Virtual disk model
 * @property bus Gets or sets the disk bus.
 * @property busType Gets or sets the disk bus type.
 * @property createDiffDisk Gets or sets a value indicating diff disk.
 * @property diskId Gets or sets the disk id.
 * @property diskSizeGB Gets or sets the disk total size.
 * @property lun Gets or sets the disk lun.
 * @property name Gets or sets the name of the disk.
 * @property storageQoSPolicy The QoS policy for the disk.
 * @property templateDiskId Gets or sets the disk id in the template.
 * @property vhdType Gets or sets the disk vhd type.
 */
public data class VirtualDiskArgs(
    public val bus: Output<Int>? = null,
    public val busType: Output<String>? = null,
    public val createDiffDisk: Output<Either<String, CreateDiffDisk>>? = null,
    public val diskId: Output<String>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val lun: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val storageQoSPolicy: Output<StorageQoSPolicyDetailsArgs>? = null,
    public val templateDiskId: Output<String>? = null,
    public val vhdType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.VirtualDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.VirtualDiskArgs =
        com.pulumi.azurenative.scvmm.inputs.VirtualDiskArgs.builder()
            .bus(bus?.applyValue({ args0 -> args0 }))
            .busType(busType?.applyValue({ args0 -> args0 }))
            .createDiffDisk(
                createDiffDisk?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .lun(lun?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .storageQoSPolicy(storageQoSPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .templateDiskId(templateDiskId?.applyValue({ args0 -> args0 }))
            .vhdType(vhdType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualDiskArgs].
 */
@PulumiTagMarker
public class VirtualDiskArgsBuilder internal constructor() {
    private var bus: Output<Int>? = null

    private var busType: Output<String>? = null

    private var createDiffDisk: Output<Either<String, CreateDiffDisk>>? = null

    private var diskId: Output<String>? = null

    private var diskSizeGB: Output<Int>? = null

    private var lun: Output<Int>? = null

    private var name: Output<String>? = null

    private var storageQoSPolicy: Output<StorageQoSPolicyDetailsArgs>? = null

    private var templateDiskId: Output<String>? = null

    private var vhdType: Output<String>? = null

    /**
     * @param value Gets or sets the disk bus.
     */
    @JvmName("hdnsrhmkjnqkpbqc")
    public suspend fun bus(`value`: Output<Int>) {
        this.bus = value
    }

    /**
     * @param value Gets or sets the disk bus type.
     */
    @JvmName("ueacfyxcxntnwymb")
    public suspend fun busType(`value`: Output<String>) {
        this.busType = value
    }

    /**
     * @param value Gets or sets a value indicating diff disk.
     */
    @JvmName("lwswgnnfxgewobrg")
    public suspend fun createDiffDisk(`value`: Output<Either<String, CreateDiffDisk>>) {
        this.createDiffDisk = value
    }

    /**
     * @param value Gets or sets the disk id.
     */
    @JvmName("mnxistvtvejjksbg")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value Gets or sets the disk total size.
     */
    @JvmName("ttpvyfikusdcwtqq")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Gets or sets the disk lun.
     */
    @JvmName("oqwdpyrnohxdiffy")
    public suspend fun lun(`value`: Output<Int>) {
        this.lun = value
    }

    /**
     * @param value Gets or sets the name of the disk.
     */
    @JvmName("nivvlrepnvjikuwt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The QoS policy for the disk.
     */
    @JvmName("ilgjekvlodscndna")
    public suspend fun storageQoSPolicy(`value`: Output<StorageQoSPolicyDetailsArgs>) {
        this.storageQoSPolicy = value
    }

    /**
     * @param value Gets or sets the disk id in the template.
     */
    @JvmName("sgoogipwrwyjhlvv")
    public suspend fun templateDiskId(`value`: Output<String>) {
        this.templateDiskId = value
    }

    /**
     * @param value Gets or sets the disk vhd type.
     */
    @JvmName("purgrqnaiiidirqa")
    public suspend fun vhdType(`value`: Output<String>) {
        this.vhdType = value
    }

    /**
     * @param value Gets or sets the disk bus.
     */
    @JvmName("dgxsxomxmjarbyfj")
    public suspend fun bus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bus = mapped
    }

    /**
     * @param value Gets or sets the disk bus type.
     */
    @JvmName("aonvtwsfuegxjlcl")
    public suspend fun busType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.busType = mapped
    }

    /**
     * @param value Gets or sets a value indicating diff disk.
     */
    @JvmName("vegfwrgkgqjoojxc")
    public suspend fun createDiffDisk(`value`: Either<String, CreateDiffDisk>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createDiffDisk = mapped
    }

    /**
     * @param value Gets or sets a value indicating diff disk.
     */
    @JvmName("doijrshbivmwpsai")
    public fun createDiffDisk(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateDiffDisk>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createDiffDisk = mapped
    }

    /**
     * @param value Gets or sets a value indicating diff disk.
     */
    @JvmName("kvygwxgniyxvcyaf")
    public fun createDiffDisk(`value`: CreateDiffDisk) {
        val toBeMapped = Either.ofRight<String, CreateDiffDisk>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createDiffDisk = mapped
    }

    /**
     * @param value Gets or sets the disk id.
     */
    @JvmName("jrcqeqiictwxfisj")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value Gets or sets the disk total size.
     */
    @JvmName("nlnteuuowipgglwb")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Gets or sets the disk lun.
     */
    @JvmName("webamgbedgvrjude")
    public suspend fun lun(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lun = mapped
    }

    /**
     * @param value Gets or sets the name of the disk.
     */
    @JvmName("vjxaadxjdxtxlvmc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The QoS policy for the disk.
     */
    @JvmName("tgmcocvnmesstndb")
    public suspend fun storageQoSPolicy(`value`: StorageQoSPolicyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageQoSPolicy = mapped
    }

    /**
     * @param argument The QoS policy for the disk.
     */
    @JvmName("omaqtyomfdqsljrt")
    public suspend
    fun storageQoSPolicy(argument: suspend StorageQoSPolicyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = StorageQoSPolicyDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageQoSPolicy = mapped
    }

    /**
     * @param value Gets or sets the disk id in the template.
     */
    @JvmName("lrjaumksmkrlmmie")
    public suspend fun templateDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateDiskId = mapped
    }

    /**
     * @param value Gets or sets the disk vhd type.
     */
    @JvmName("dkwmmnvrtycauyjv")
    public suspend fun vhdType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhdType = mapped
    }

    internal fun build(): VirtualDiskArgs = VirtualDiskArgs(
        bus = bus,
        busType = busType,
        createDiffDisk = createDiffDisk,
        diskId = diskId,
        diskSizeGB = diskSizeGB,
        lun = lun,
        name = name,
        storageQoSPolicy = storageQoSPolicy,
        templateDiskId = templateDiskId,
        vhdType = vhdType,
    )
}
