@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the GuestAgent.
 * @property credentials Username / Password Credentials to provision guest agent.
 * @property customResourceName Gets the name of the corresponding resource in Kubernetes.
 * @property httpProxyConfig HTTP Proxy configuration for the VM.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningAction Gets or sets the guest agent provisioning action.
 * @property provisioningState Gets or sets the provisioning state.
 * @property status Gets or sets the guest agent status.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property uuid Gets or sets a unique identifier for this resource.
 */
public data class GetGuestAgentResult(
    public val credentials: GuestCredentialResponse? = null,
    public val customResourceName: String,
    public val httpProxyConfig: HttpProxyConfigurationResponse? = null,
    public val id: String,
    public val name: String,
    public val provisioningAction: String? = null,
    public val provisioningState: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val uuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetGuestAgentResult):
            GetGuestAgentResult = GetGuestAgentResult(
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.GuestCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customResourceName = javaType.customResourceName(),
            httpProxyConfig = javaType.httpProxyConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.HttpProxyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningAction = javaType.provisioningAction().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            uuid = javaType.uuid(),
        )
    }
}
