@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Virtual disk model
 * @property bus Gets or sets the disk bus.
 * @property busType Gets or sets the disk bus type.
 * @property createDiffDisk Gets or sets a value indicating diff disk.
 * @property diskId Gets or sets the disk id.
 * @property diskSizeGB Gets or sets the disk total size.
 * @property displayName Gets the display name of the virtual disk as shown in the vmmServer. This is the fallback label for a disk when the name is not set.
 * @property lun Gets or sets the disk lun.
 * @property maxDiskSizeGB Gets or sets the max disk size.
 * @property name Gets or sets the name of the disk.
 * @property storageQoSPolicy The QoS policy for the disk.
 * @property templateDiskId Gets or sets the disk id in the template.
 * @property vhdFormatType Gets the disk vhd format type.
 * @property vhdType Gets or sets the disk vhd type.
 * @property volumeType Gets or sets the disk volume type.
 */
public data class VirtualDiskResponse(
    public val bus: Int? = null,
    public val busType: String? = null,
    public val createDiffDisk: String? = null,
    public val diskId: String? = null,
    public val diskSizeGB: Int? = null,
    public val displayName: String,
    public val lun: Int? = null,
    public val maxDiskSizeGB: Int,
    public val name: String? = null,
    public val storageQoSPolicy: StorageQoSPolicyDetailsResponse? = null,
    public val templateDiskId: String? = null,
    public val vhdFormatType: String,
    public val vhdType: String? = null,
    public val volumeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.VirtualDiskResponse):
            VirtualDiskResponse = VirtualDiskResponse(
            bus = javaType.bus().map({ args0 -> args0 }).orElse(null),
            busType = javaType.busType().map({ args0 -> args0 }).orElse(null),
            createDiffDisk = javaType.createDiffDisk().map({ args0 -> args0 }).orElse(null),
            diskId = javaType.diskId().map({ args0 -> args0 }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            lun = javaType.lun().map({ args0 -> args0 }).orElse(null),
            maxDiskSizeGB = javaType.maxDiskSizeGB(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            storageQoSPolicy = javaType.storageQoSPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.StorageQoSPolicyDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            templateDiskId = javaType.templateDiskId().map({ args0 -> args0 }).orElse(null),
            vhdFormatType = javaType.vhdFormatType(),
            vhdType = javaType.vhdType().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType(),
        )
    }
}
