@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin

import com.pulumi.azurenative.search.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.search.kotlin.inputs.PrivateEndpointConnectionPropertiesArgs
import com.pulumi.azurenative.search.kotlin.inputs.PrivateEndpointConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes an existing Private Endpoint connection to the Azure Cognitive Search service.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2019-10-01-preview, 2023-11-01, 2024-03-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Search.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "testEndpoint.50bf4fbe-d7c1-4b48-a642-4f5892642546",
 *         Properties = new AzureNative.Search.Inputs.PrivateEndpointConnectionPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.Search.Inputs.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs
 *             {
 *                 Description = "Rejected for some reason",
 *                 Status = AzureNative.Search.PrivateLinkServiceConnectionStatus.Rejected,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &search.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("testEndpoint.50bf4fbe-d7c1-4b48-a642-4f5892642546"),
 * 			Properties: &search.PrivateEndpointConnectionPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &search.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs{
 * 					Description: pulumi.String("Rejected for some reason"),
 * 					Status:      search.PrivateLinkServiceConnectionStatusRejected,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SearchServiceName: pulumi.String("mysearchservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.PrivateEndpointConnection;
 * import com.pulumi.azurenative.search.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesArgs;
 * import com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("testEndpoint.50bf4fbe-d7c1-4b48-a642-4f5892642546")
 *             .properties(PrivateEndpointConnectionPropertiesArgs.builder()
 *                 .privateLinkServiceConnectionState(PrivateEndpointConnectionPropertiesPrivateLinkServiceConnectionStateArgs.builder()
 *                     .description("Rejected for some reason")
 *                     .status("Rejected")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:search:PrivateEndpointConnection testEndpoint.50bf4fbe-d7c1-4b48-a642-4f5892642546 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName The name of the private endpoint connection to the Azure Cognitive Search service with the specified resource group.
 * @property properties Describes the properties of an existing Private Endpoint connection to the Azure Cognitive Search service.
 * @property resourceGroupName The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property searchServiceName The name of the Azure Cognitive Search service associated with the specified resource group.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val searchServiceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.search.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.search.PrivateEndpointConnectionArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .searchServiceName(searchServiceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var searchServiceName: Output<String>? = null

    /**
     * @param value The name of the private endpoint connection to the Azure Cognitive Search service with the specified resource group.
     */
    @JvmName("dtrjthkmwcerrmmk")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Describes the properties of an existing Private Endpoint connection to the Azure Cognitive Search service.
     */
    @JvmName("qfvtqaxxvyonkbis")
    public suspend fun properties(`value`: Output<PrivateEndpointConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rytyvucvccniloer")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Cognitive Search service associated with the specified resource group.
     */
    @JvmName("rielbbbxsgntcxet")
    public suspend fun searchServiceName(`value`: Output<String>) {
        this.searchServiceName = value
    }

    /**
     * @param value The name of the private endpoint connection to the Azure Cognitive Search service with the specified resource group.
     */
    @JvmName("qafgkdshvxnnafkd")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Describes the properties of an existing Private Endpoint connection to the Azure Cognitive Search service.
     */
    @JvmName("hbcycwmhsqamssyw")
    public suspend fun properties(`value`: PrivateEndpointConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Describes the properties of an existing Private Endpoint connection to the Azure Cognitive Search service.
     */
    @JvmName("klvwmrrghbjnqmkj")
    public suspend
    fun properties(argument: suspend PrivateEndpointConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hqmvwgaqjrrcwdjm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Cognitive Search service associated with the specified resource group.
     */
    @JvmName("kgwhbsakappynwxe")
    public suspend fun searchServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchServiceName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpointConnectionName = privateEndpointConnectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        searchServiceName = searchServiceName,
    )
}
