@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin

import com.pulumi.azurenative.search.kotlin.outputs.SharedPrivateLinkResourcePropertiesResponse
import com.pulumi.azurenative.search.kotlin.outputs.SharedPrivateLinkResourcePropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SharedPrivateLinkResource].
 */
@PulumiTagMarker
public class SharedPrivateLinkResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SharedPrivateLinkResourceArgs = SharedPrivateLinkResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SharedPrivateLinkResourceArgsBuilder.() -> Unit) {
        val builder = SharedPrivateLinkResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SharedPrivateLinkResource {
        val builtJavaResource =
            com.pulumi.azurenative.search.SharedPrivateLinkResource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SharedPrivateLinkResource(builtJavaResource)
    }
}

/**
 * Describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2023-11-01, 2024-03-01-preview.
 * ## Example Usage
 * ### SharedPrivateLinkResourceCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sharedPrivateLinkResource = new AzureNative.Search.SharedPrivateLinkResource("sharedPrivateLinkResource", new()
 *     {
 *         Properties = new AzureNative.Search.Inputs.SharedPrivateLinkResourcePropertiesArgs
 *         {
 *             GroupId = "blob",
 *             PrivateLinkResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/storageAccountName",
 *             RequestMessage = "please approve",
 *         },
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         SharedPrivateLinkResourceName = "testResource",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewSharedPrivateLinkResource(ctx, "sharedPrivateLinkResource", &search.SharedPrivateLinkResourceArgs{
 * 			Properties: &search.SharedPrivateLinkResourcePropertiesArgs{
 * 				GroupId:               pulumi.String("blob"),
 * 				PrivateLinkResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/storageAccountName"),
 * 				RequestMessage:        pulumi.String("please approve"),
 * 			},
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 			SearchServiceName:             pulumi.String("mysearchservice"),
 * 			SharedPrivateLinkResourceName: pulumi.String("testResource"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.SharedPrivateLinkResource;
 * import com.pulumi.azurenative.search.SharedPrivateLinkResourceArgs;
 * import com.pulumi.azurenative.search.inputs.SharedPrivateLinkResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sharedPrivateLinkResource = new SharedPrivateLinkResource("sharedPrivateLinkResource", SharedPrivateLinkResourceArgs.builder()
 *             .properties(SharedPrivateLinkResourcePropertiesArgs.builder()
 *                 .groupId("blob")
 *                 .privateLinkResourceId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/storageAccountName")
 *                 .requestMessage("please approve")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sharedPrivateLinkResourceName("testResource")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:search:SharedPrivateLinkResource testResource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}
 * ```
 */
public class SharedPrivateLinkResource internal constructor(
    override val javaResource: com.pulumi.azurenative.search.SharedPrivateLinkResource,
) : KotlinCustomResource(javaResource, SharedPrivateLinkResourceMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes the properties of a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    public val properties: Output<SharedPrivateLinkResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SharedPrivateLinkResourceMapper : ResourceMapper<SharedPrivateLinkResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.search.SharedPrivateLinkResource::class == javaResource::class

    override fun map(javaResource: Resource): SharedPrivateLinkResource =
        SharedPrivateLinkResource(
            javaResource as
                com.pulumi.azurenative.search.SharedPrivateLinkResource,
        )
}

/**
 * @see [SharedPrivateLinkResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SharedPrivateLinkResource].
 */
public suspend fun sharedPrivateLinkResource(
    name: String,
    block: suspend SharedPrivateLinkResourceResourceBuilder.() -> Unit,
): SharedPrivateLinkResource {
    val builder = SharedPrivateLinkResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SharedPrivateLinkResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sharedPrivateLinkResource(name: String): SharedPrivateLinkResource {
    val builder = SharedPrivateLinkResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
