@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Applicable only for the standard3 SKU. You can set this property to enable up to 3 high density partitions that allow up to 1000 indexes, which is much higher than the maximum indexes allowed for any other SKU. For the standard3 SKU, the value is either 'default' or 'highDensity'. For all other SKUs, this value must be 'default'.
 */
public enum class HostingMode(
    public val javaValue: com.pulumi.azurenative.search.enums.HostingMode,
) : ConvertibleToJava<com.pulumi.azurenative.search.enums.HostingMode> {
    /**
     * The limit on number of indexes is determined by the default limits for the SKU.
     */
    Default(com.pulumi.azurenative.search.enums.HostingMode.Default),

    /**
     * Only application for standard3 SKU, where the search service can have up to 1000 indexes.
     */
    HighDensity(com.pulumi.azurenative.search.enums.HostingMode.HighDensity),
    ;

    override fun toJava(): com.pulumi.azurenative.search.enums.HostingMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.enums.HostingMode): HostingMode =
            HostingMode.values().first { it.javaValue == javaType }
    }
}
