@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.search.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.search.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.search.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.search.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.search.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
