@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The private endpoint resource from Microsoft.Network provider.
 * @property id The resource id of the private endpoint resource from Microsoft.Network provider.
 */
public data class PrivateEndpointConnectionPropertiesPrivateEndpointArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateEndpointArgs> {
    override fun toJava():
        com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateEndpointArgs =
        com.pulumi.azurenative.search.inputs.PrivateEndpointConnectionPropertiesPrivateEndpointArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionPropertiesPrivateEndpointArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionPropertiesPrivateEndpointArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The resource id of the private endpoint resource from Microsoft.Network provider.
     */
    @JvmName("bhvmuyymxolxltxg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The resource id of the private endpoint resource from Microsoft.Network provider.
     */
    @JvmName("jglbtfkvpoddqnjv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): PrivateEndpointConnectionPropertiesPrivateEndpointArgs =
        PrivateEndpointConnectionPropertiesPrivateEndpointArgs(
            id = id,
        )
}
