@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.SharedPrivateLinkResourcePropertiesArgs.builder
import com.pulumi.azurenative.search.kotlin.enums.SharedPrivateLinkResourceProvisioningState
import com.pulumi.azurenative.search.kotlin.enums.SharedPrivateLinkResourceStatus
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of an existing Shared Private Link Resource managed by the Azure Cognitive Search service.
 * @property groupId The group id from the provider of resource the shared private link resource is for.
 * @property privateLinkResourceId The resource id of the resource the shared private link resource is for.
 * @property provisioningState The provisioning state of the shared private link resource. Can be Updating, Deleting, Failed, Succeeded or Incomplete.
 * @property requestMessage The request message for requesting approval of the shared private link resource.
 * @property resourceRegion Optional. Can be used to specify the Azure Resource Manager location of the resource to which a shared private link is to be created. This is only required for those resources whose DNS configuration are regional (such as Azure Kubernetes Service).
 * @property status Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
 */
public data class SharedPrivateLinkResourcePropertiesArgs(
    public val groupId: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val provisioningState: Output<SharedPrivateLinkResourceProvisioningState>? = null,
    public val requestMessage: Output<String>? = null,
    public val resourceRegion: Output<String>? = null,
    public val status: Output<SharedPrivateLinkResourceStatus>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.SharedPrivateLinkResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.search.inputs.SharedPrivateLinkResourcePropertiesArgs =
        com.pulumi.azurenative.search.inputs.SharedPrivateLinkResourcePropertiesArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 }))
            .resourceRegion(resourceRegion?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SharedPrivateLinkResourcePropertiesArgs].
 */
@PulumiTagMarker
public class SharedPrivateLinkResourcePropertiesArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var provisioningState: Output<SharedPrivateLinkResourceProvisioningState>? = null

    private var requestMessage: Output<String>? = null

    private var resourceRegion: Output<String>? = null

    private var status: Output<SharedPrivateLinkResourceStatus>? = null

    /**
     * @param value The group id from the provider of resource the shared private link resource is for.
     */
    @JvmName("ivbtplpbggepsmlp")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The resource id of the resource the shared private link resource is for.
     */
    @JvmName("knftqqxjwgevukaq")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value The provisioning state of the shared private link resource. Can be Updating, Deleting, Failed, Succeeded or Incomplete.
     */
    @JvmName("rxhpysdichicstme")
    public suspend
    fun provisioningState(`value`: Output<SharedPrivateLinkResourceProvisioningState>) {
        this.provisioningState = value
    }

    /**
     * @param value The request message for requesting approval of the shared private link resource.
     */
    @JvmName("swibjpquspslqcph")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value Optional. Can be used to specify the Azure Resource Manager location of the resource to which a shared private link is to be created. This is only required for those resources whose DNS configuration are regional (such as Azure Kubernetes Service).
     */
    @JvmName("tkrkvxjxihovffrr")
    public suspend fun resourceRegion(`value`: Output<String>) {
        this.resourceRegion = value
    }

    /**
     * @param value Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
     */
    @JvmName("abaibatmxctyqqjn")
    public suspend fun status(`value`: Output<SharedPrivateLinkResourceStatus>) {
        this.status = value
    }

    /**
     * @param value The group id from the provider of resource the shared private link resource is for.
     */
    @JvmName("renromeluchqlcvt")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The resource id of the resource the shared private link resource is for.
     */
    @JvmName("cjaodgwpdlnnfwxs")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value The provisioning state of the shared private link resource. Can be Updating, Deleting, Failed, Succeeded or Incomplete.
     */
    @JvmName("rwqlpvvidkmljsgu")
    public suspend fun provisioningState(`value`: SharedPrivateLinkResourceProvisioningState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The request message for requesting approval of the shared private link resource.
     */
    @JvmName("svdryropyodhlmum")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    /**
     * @param value Optional. Can be used to specify the Azure Resource Manager location of the resource to which a shared private link is to be created. This is only required for those resources whose DNS configuration are regional (such as Azure Kubernetes Service).
     */
    @JvmName("mdgpmrqfjoavexel")
    public suspend fun resourceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRegion = mapped
    }

    /**
     * @param value Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected.
     */
    @JvmName("fbyicbikisjougbu")
    public suspend fun status(`value`: SharedPrivateLinkResourceStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): SharedPrivateLinkResourcePropertiesArgs =
        SharedPrivateLinkResourcePropertiesArgs(
            groupId = groupId,
            privateLinkResourceId = privateLinkResourceId,
            provisioningState = provisioningState,
            requestMessage = requestMessage,
            resourceRegion = resourceRegion,
            status = status,
        )
}
