@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The IP restriction rule of the Azure Cognitive Search service.
 * @property value Value corresponding to a single IPv4 address (eg., 123.1.2.3) or an IP range in CIDR format (eg., 123.1.2.3/24) to be allowed.
 */
public data class IpRuleResponse(
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.IpRuleResponse):
            IpRuleResponse = IpRuleResponse(
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
