@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [APICollectionByAzureApiManagementService].
 */
@PulumiTagMarker
public class APICollectionByAzureApiManagementServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: APICollectionByAzureApiManagementServiceArgs =
        APICollectionByAzureApiManagementServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend APICollectionByAzureApiManagementServiceArgsBuilder.() -> Unit) {
        val builder = APICollectionByAzureApiManagementServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): APICollectionByAzureApiManagementService {
        val builtJavaResource =
            com.pulumi.azurenative.security.APICollectionByAzureApiManagementService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return APICollectionByAzureApiManagementService(builtJavaResource)
    }
}

/**
 * An API collection as represented by Microsoft Defender for APIs.
 * Azure REST API version: 2023-11-15.
 * ## Example Usage
 * ### Onboard an Azure API Management API to Microsoft Defender for APIs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiCollectionByAzureApiManagementService = new AzureNative.Security.APICollectionByAzureApiManagementService("apiCollectionByAzureApiManagementService", new()
 *     {
 *         ApiId = "echo-api",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAPICollectionByAzureApiManagementService(ctx, "apiCollectionByAzureApiManagementService", &security.APICollectionByAzureApiManagementServiceArgs{
 * 			ApiId:             pulumi.String("echo-api"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.APICollectionByAzureApiManagementService;
 * import com.pulumi.azurenative.security.APICollectionByAzureApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiCollectionByAzureApiManagementService = new APICollectionByAzureApiManagementService("apiCollectionByAzureApiManagementService", APICollectionByAzureApiManagementServiceArgs.builder()
 *             .apiId("echo-api")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:APICollectionByAzureApiManagementService echo-api /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/providers/Microsoft.Security/apiCollections/{apiId}
 * ```
 */
public class APICollectionByAzureApiManagementService internal constructor(
    override val javaResource:
    com.pulumi.azurenative.security.APICollectionByAzureApiManagementService,
) : KotlinCustomResource(javaResource, APICollectionByAzureApiManagementServiceMapper) {
    /**
     * The base URI for this API collection. All endpoints of this API collection extend this base URI.
     */
    public val baseUrl: Output<String>
        get() = javaResource.baseUrl().applyValue({ args0 -> args0 })

    /**
     * The resource Id of the resource from where this API collection was discovered.
     */
    public val discoveredVia: Output<String>
        get() = javaResource.discoveredVia().applyValue({ args0 -> args0 })

    /**
     * The display name of the API collection.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of API endpoints discovered in this API collection.
     */
    public val numberOfApiEndpoints: Output<Double>
        get() = javaResource.numberOfApiEndpoints().applyValue({ args0 -> args0 })

    /**
     * The number of API endpoints in this API collection which are exposing sensitive data in their requests and/or responses.
     */
    public val numberOfApiEndpointsWithSensitiveDataExposed: Output<Double>
        get() = javaResource.numberOfApiEndpointsWithSensitiveDataExposed().applyValue({ args0 -> args0 })

    /**
     * The number of API endpoints in this API collection for which API traffic from the internet was observed.
     */
    public val numberOfExternalApiEndpoints: Output<Double>
        get() = javaResource.numberOfExternalApiEndpoints().applyValue({ args0 -> args0 })

    /**
     * The number of API endpoints in this API collection that have not received any API traffic in the last 30 days.
     */
    public val numberOfInactiveApiEndpoints: Output<Double>
        get() = javaResource.numberOfInactiveApiEndpoints().applyValue({ args0 -> args0 })

    /**
     * The number of API endpoints in this API collection that are unauthenticated.
     */
    public val numberOfUnauthenticatedApiEndpoints: Output<Double>
        get() = javaResource.numberOfUnauthenticatedApiEndpoints().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the API collection.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The highest priority sensitivity label from Microsoft Purview in this API collection.
     */
    public val sensitivityLabel: Output<String>
        get() = javaResource.sensitivityLabel().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object APICollectionByAzureApiManagementServiceMapper :
    ResourceMapper<APICollectionByAzureApiManagementService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.APICollectionByAzureApiManagementService::class == javaResource::class

    override fun map(javaResource: Resource): APICollectionByAzureApiManagementService =
        APICollectionByAzureApiManagementService(
            javaResource as
                com.pulumi.azurenative.security.APICollectionByAzureApiManagementService,
        )
}

/**
 * @see [APICollectionByAzureApiManagementService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [APICollectionByAzureApiManagementService].
 */
public suspend fun apiCollectionByAzureApiManagementService(
    name: String,
    block: suspend APICollectionByAzureApiManagementServiceResourceBuilder.() -> Unit,
):
    APICollectionByAzureApiManagementService {
    val builder = APICollectionByAzureApiManagementServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [APICollectionByAzureApiManagementService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiCollectionByAzureApiManagementService(name: String):
    APICollectionByAzureApiManagementService {
    val builder = APICollectionByAzureApiManagementServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
