@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.APICollectionByAzureApiManagementServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An API collection as represented by Microsoft Defender for APIs.
 * Azure REST API version: 2023-11-15.
 * ## Example Usage
 * ### Onboard an Azure API Management API to Microsoft Defender for APIs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiCollectionByAzureApiManagementService = new AzureNative.Security.APICollectionByAzureApiManagementService("apiCollectionByAzureApiManagementService", new()
 *     {
 *         ApiId = "echo-api",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAPICollectionByAzureApiManagementService(ctx, "apiCollectionByAzureApiManagementService", &security.APICollectionByAzureApiManagementServiceArgs{
 * 			ApiId:             pulumi.String("echo-api"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.APICollectionByAzureApiManagementService;
 * import com.pulumi.azurenative.security.APICollectionByAzureApiManagementServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiCollectionByAzureApiManagementService = new APICollectionByAzureApiManagementService("apiCollectionByAzureApiManagementService", APICollectionByAzureApiManagementServiceArgs.builder()
 *             .apiId("echo-api")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:APICollectionByAzureApiManagementService echo-api /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/providers/Microsoft.Security/apiCollections/{apiId}
 * ```
 * @property apiId API revision identifier. Must be unique in the API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class APICollectionByAzureApiManagementServiceArgs(
    public val apiId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.APICollectionByAzureApiManagementServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.APICollectionByAzureApiManagementServiceArgs =
        com.pulumi.azurenative.security.APICollectionByAzureApiManagementServiceArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [APICollectionByAzureApiManagementServiceArgs].
 */
@PulumiTagMarker
public class APICollectionByAzureApiManagementServiceArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value API revision identifier. Must be unique in the API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("xeoqvtcklemhwctj")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xjieglasvxoiphbu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("uilxnmwimavmaavr")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value API revision identifier. Must be unique in the API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("urebobgfuuqmxsnl")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pkrgbknsemwlouiv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("otikiickcwkiukel")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): APICollectionByAzureApiManagementServiceArgs =
        APICollectionByAzureApiManagementServiceArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
}
