@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.AssignedComponentItemResponse
import com.pulumi.azurenative.security.kotlin.outputs.AssignedStandardItemResponse
import com.pulumi.azurenative.security.kotlin.outputs.AssignmentPropertiesResponseAdditionalData
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.security.kotlin.outputs.AssignedComponentItemResponse.Companion.toKotlin as assignedComponentItemResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.AssignedStandardItemResponse.Companion.toKotlin as assignedStandardItemResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.AssignmentPropertiesResponseAdditionalData.Companion.toKotlin as assignmentPropertiesResponseAdditionalDataToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Assignment].
 */
@PulumiTagMarker
public class AssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssignmentArgs = AssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssignmentArgsBuilder.() -> Unit) {
        val builder = AssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Assignment {
        val builtJavaResource = com.pulumi.azurenative.security.Assignment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Assignment(builtJavaResource)
    }
}

/**
 * Security Assignment on a resource group over a given scope
 * Azure REST API version: 2021-08-01-preview. Prior API version in Azure Native 1.x: 2021-08-01-preview.
 * ## Example Usage
 * ### Define a default standard assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Security.Assignment("assignment", new()
 *     {
 *         AssignedStandard = new AzureNative.Security.Inputs.AssignedStandardItemArgs
 *         {
 *             Id = "/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8",
 *         },
 *         AssignmentId = "1f3afdf9-d0c9-4c3d-847f-89da613e70a8",
 *         Description = "Set of policies monitored by Azure Security Center for cross cloud",
 *         DisplayName = "ASC Default",
 *         Effect = "audit",
 *         ResourceGroupName = "myResourceGroup",
 *         Scope = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssignment(ctx, "assignment", &security.AssignmentArgs{
 * 			AssignedStandard: &security.AssignedStandardItemArgs{
 * 				Id: pulumi.String("/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
 * 			},
 * 			AssignmentId:      pulumi.String("1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
 * 			Description:       pulumi.String("Set of policies monitored by Azure Security Center for cross cloud"),
 * 			DisplayName:       pulumi.String("ASC Default"),
 * 			Effect:            pulumi.String("audit"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Scope:             pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Assignment;
 * import com.pulumi.azurenative.security.AssignmentArgs;
 * import com.pulumi.azurenative.security.inputs.AssignedStandardItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignedStandard(AssignedStandardItemArgs.builder()
 *                 .id("/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8")
 *                 .build())
 *             .assignmentId("1f3afdf9-d0c9-4c3d-847f-89da613e70a8")
 *             .description("Set of policies monitored by Azure Security Center for cross cloud")
 *             .displayName("ASC Default")
 *             .effect("audit")
 *             .resourceGroupName("myResourceGroup")
 *             .scope("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Exempt Recommendation From standard and resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Security.Assignment("assignment", new()
 *     {
 *         AdditionalData = new AzureNative.Security.Inputs.AssignmentPropertiesAdditionalDataArgs
 *         {
 *             ExemptionCategory = "waiver",
 *         },
 *         AssignedComponent = new AzureNative.Security.Inputs.AssignedComponentItemArgs
 *         {
 *             Key = "1195afff-c881-495e-9bc5-1486211ae03f",
 *         },
 *         AssignedStandard = new AzureNative.Security.Inputs.AssignedStandardItemArgs
 *         {
 *             Id = "/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8",
 *         },
 *         AssignmentId = "1f3afdf9-d0c9-4c3d-847f-89da613e70a8",
 *         Description = "Set of policies monitored by Azure Security Center for cross cloud",
 *         DisplayName = "ASC Default",
 *         Effect = "Exempt",
 *         ExpiresOn = "2022-05-01T19:50:47.083633Z",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["ticketId"] = 12345,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Scope = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssignment(ctx, "assignment", &security.AssignmentArgs{
 * 			AdditionalData: &security.AssignmentPropertiesAdditionalDataArgs{
 * 				ExemptionCategory: pulumi.String("waiver"),
 * 			},
 * 			AssignedComponent: &security.AssignedComponentItemArgs{
 * 				Key: pulumi.String("1195afff-c881-495e-9bc5-1486211ae03f"),
 * 			},
 * 			AssignedStandard: &security.AssignedStandardItemArgs{
 * 				Id: pulumi.String("/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
 * 			},
 * 			AssignmentId: pulumi.String("1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
 * 			Description:  pulumi.String("Set of policies monitored by Azure Security Center for cross cloud"),
 * 			DisplayName:  pulumi.String("ASC Default"),
 * 			Effect:       pulumi.String("Exempt"),
 * 			ExpiresOn:    pulumi.String("2022-05-01T19:50:47.083633Z"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"ticketId": 12345,
 * 			}),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Scope:             pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Assignment;
 * import com.pulumi.azurenative.security.AssignmentArgs;
 * import com.pulumi.azurenative.security.inputs.AssignmentPropertiesAdditionalDataArgs;
 * import com.pulumi.azurenative.security.inputs.AssignedComponentItemArgs;
 * import com.pulumi.azurenative.security.inputs.AssignedStandardItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .additionalData(AssignmentPropertiesAdditionalDataArgs.builder()
 *                 .exemptionCategory("waiver")
 *                 .build())
 *             .assignedComponent(AssignedComponentItemArgs.builder()
 *                 .key("1195afff-c881-495e-9bc5-1486211ae03f")
 *                 .build())
 *             .assignedStandard(AssignedStandardItemArgs.builder()
 *                 .id("/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8")
 *                 .build())
 *             .assignmentId("1f3afdf9-d0c9-4c3d-847f-89da613e70a8")
 *             .description("Set of policies monitored by Azure Security Center for cross cloud")
 *             .displayName("ASC Default")
 *             .effect("Exempt")
 *             .expiresOn("2022-05-01T19:50:47.083633Z")
 *             .metadata(Map.of("ticketId", 12345))
 *             .resourceGroupName("myResourceGroup")
 *             .scope("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Assignment 1f3afdf9-d0c9-4c3d-847f-89da613e70a8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/assignments/{assignmentId}
 * ```
 */
public class Assignment internal constructor(
    override val javaResource: com.pulumi.azurenative.security.Assignment,
) : KotlinCustomResource(javaResource, AssignmentMapper) {
    /**
     * Additional data about the assignment
     */
    public val additionalData: Output<AssignmentPropertiesResponseAdditionalData>?
        get() = javaResource.additionalData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    assignmentPropertiesResponseAdditionalDataToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Component item with key as applied to this standard assignment over the given scope
     */
    public val assignedComponent: Output<AssignedComponentItemResponse>?
        get() = javaResource.assignedComponent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> assignedComponentItemResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Standard item with key as applied to this standard assignment over the given scope
     */
    public val assignedStandard: Output<AssignedStandardItemResponse>?
        get() = javaResource.assignedStandard().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> assignedStandardItemResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * description of the standardAssignment
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * display name of the standardAssignment
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * expected effect of this assignment (Disable/Exempt/etc)
     */
    public val effect: Output<String>?
        get() = javaResource.effect().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Entity tag is used for comparing two or more entities from the same requested resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Expiration date of this assignment as a full ISO date
     */
    public val expiresOn: Output<String>?
        get() = javaResource.expiresOn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of the resource
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Location where the resource is stored
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Scope to which the standardAssignment applies - can be a subscription path or a resource group under that subscription
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * A list of key value pairs that describe the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AssignmentMapper : ResourceMapper<Assignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.Assignment::class == javaResource::class

    override fun map(javaResource: Resource): Assignment = Assignment(
        javaResource as
            com.pulumi.azurenative.security.Assignment,
    )
}

/**
 * @see [Assignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Assignment].
 */
public suspend fun assignment(name: String, block: suspend AssignmentResourceBuilder.() -> Unit):
    Assignment {
    val builder = AssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Assignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assignment(name: String): Assignment {
    val builder = AssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
