@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AssignmentArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.AssignedComponentItemArgs
import com.pulumi.azurenative.security.kotlin.inputs.AssignedComponentItemArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.AssignedStandardItemArgs
import com.pulumi.azurenative.security.kotlin.inputs.AssignedStandardItemArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.AssignmentPropertiesAdditionalDataArgs
import com.pulumi.azurenative.security.kotlin.inputs.AssignmentPropertiesAdditionalDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Security Assignment on a resource group over a given scope
 * Azure REST API version: 2021-08-01-preview. Prior API version in Azure Native 1.x: 2021-08-01-preview.
 * ## Example Usage
 * ### Define a default standard assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Security.Assignment("assignment", new()
 *     {
 *         AssignedStandard = new AzureNative.Security.Inputs.AssignedStandardItemArgs
 *         {
 *             Id = "/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8",
 *         },
 *         AssignmentId = "1f3afdf9-d0c9-4c3d-847f-89da613e70a8",
 *         Description = "Set of policies monitored by Azure Security Center for cross cloud",
 *         DisplayName = "ASC Default",
 *         Effect = "audit",
 *         ResourceGroupName = "myResourceGroup",
 *         Scope = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssignment(ctx, "assignment", &security.AssignmentArgs{
 * 			AssignedStandard: &security.AssignedStandardItemArgs{
 * 				Id: pulumi.String("/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
 * 			},
 * 			AssignmentId:      pulumi.String("1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
 * 			Description:       pulumi.String("Set of policies monitored by Azure Security Center for cross cloud"),
 * 			DisplayName:       pulumi.String("ASC Default"),
 * 			Effect:            pulumi.String("audit"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Scope:             pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Assignment;
 * import com.pulumi.azurenative.security.AssignmentArgs;
 * import com.pulumi.azurenative.security.inputs.AssignedStandardItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .assignedStandard(AssignedStandardItemArgs.builder()
 *                 .id("/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8")
 *                 .build())
 *             .assignmentId("1f3afdf9-d0c9-4c3d-847f-89da613e70a8")
 *             .description("Set of policies monitored by Azure Security Center for cross cloud")
 *             .displayName("ASC Default")
 *             .effect("audit")
 *             .resourceGroupName("myResourceGroup")
 *             .scope("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg")
 *             .build());
 *     }
 * }
 * ```
 * ### Exempt Recommendation From standard and resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assignment = new AzureNative.Security.Assignment("assignment", new()
 *     {
 *         AdditionalData = new AzureNative.Security.Inputs.AssignmentPropertiesAdditionalDataArgs
 *         {
 *             ExemptionCategory = "waiver",
 *         },
 *         AssignedComponent = new AzureNative.Security.Inputs.AssignedComponentItemArgs
 *         {
 *             Key = "1195afff-c881-495e-9bc5-1486211ae03f",
 *         },
 *         AssignedStandard = new AzureNative.Security.Inputs.AssignedStandardItemArgs
 *         {
 *             Id = "/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8",
 *         },
 *         AssignmentId = "1f3afdf9-d0c9-4c3d-847f-89da613e70a8",
 *         Description = "Set of policies monitored by Azure Security Center for cross cloud",
 *         DisplayName = "ASC Default",
 *         Effect = "Exempt",
 *         ExpiresOn = "2022-05-01T19:50:47.083633Z",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["ticketId"] = 12345,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Scope = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssignment(ctx, "assignment", &security.AssignmentArgs{
 * 			AdditionalData: &security.AssignmentPropertiesAdditionalDataArgs{
 * 				ExemptionCategory: pulumi.String("waiver"),
 * 			},
 * 			AssignedComponent: &security.AssignedComponentItemArgs{
 * 				Key: pulumi.String("1195afff-c881-495e-9bc5-1486211ae03f"),
 * 			},
 * 			AssignedStandard: &security.AssignedStandardItemArgs{
 * 				Id: pulumi.String("/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
 * 			},
 * 			AssignmentId: pulumi.String("1f3afdf9-d0c9-4c3d-847f-89da613e70a8"),
 * 			Description:  pulumi.String("Set of policies monitored by Azure Security Center for cross cloud"),
 * 			DisplayName:  pulumi.String("ASC Default"),
 * 			Effect:       pulumi.String("Exempt"),
 * 			ExpiresOn:    pulumi.String("2022-05-01T19:50:47.083633Z"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"ticketId": 12345,
 * 			}),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Scope:             pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Assignment;
 * import com.pulumi.azurenative.security.AssignmentArgs;
 * import com.pulumi.azurenative.security.inputs.AssignmentPropertiesAdditionalDataArgs;
 * import com.pulumi.azurenative.security.inputs.AssignedComponentItemArgs;
 * import com.pulumi.azurenative.security.inputs.AssignedStandardItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assignment = new Assignment("assignment", AssignmentArgs.builder()
 *             .additionalData(AssignmentPropertiesAdditionalDataArgs.builder()
 *                 .exemptionCategory("waiver")
 *                 .build())
 *             .assignedComponent(AssignedComponentItemArgs.builder()
 *                 .key("1195afff-c881-495e-9bc5-1486211ae03f")
 *                 .build())
 *             .assignedStandard(AssignedStandardItemArgs.builder()
 *                 .id("/providers/Microsoft.Security/Standards/1f3afdf9-d0c9-4c3d-847f-89da613e70a8")
 *                 .build())
 *             .assignmentId("1f3afdf9-d0c9-4c3d-847f-89da613e70a8")
 *             .description("Set of policies monitored by Azure Security Center for cross cloud")
 *             .displayName("ASC Default")
 *             .effect("Exempt")
 *             .expiresOn("2022-05-01T19:50:47.083633Z")
 *             .metadata(Map.of("ticketId", 12345))
 *             .resourceGroupName("myResourceGroup")
 *             .scope("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/ResourceGroup/rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Assignment 1f3afdf9-d0c9-4c3d-847f-89da613e70a8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/assignments/{assignmentId}
 * ```
 * @property additionalData Additional data about the assignment
 * @property assignedComponent Component item with key as applied to this standard assignment over the given scope
 * @property assignedStandard Standard item with key as applied to this standard assignment over the given scope
 * @property assignmentId The security assignment key - unique key for the standard assignment
 * @property description description of the standardAssignment
 * @property displayName display name of the standardAssignment
 * @property effect expected effect of this assignment (Disable/Exempt/etc)
 * @property expiresOn Expiration date of this assignment as a full ISO date
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property metadata The assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property scope Scope to which the standardAssignment applies - can be a subscription path or a resource group under that subscription
 * @property tags A list of key value pairs that describe the resource.
 */
public data class AssignmentArgs(
    public val additionalData: Output<AssignmentPropertiesAdditionalDataArgs>? = null,
    public val assignedComponent: Output<AssignedComponentItemArgs>? = null,
    public val assignedStandard: Output<AssignedStandardItemArgs>? = null,
    public val assignmentId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val effect: Output<String>? = null,
    public val expiresOn: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AssignmentArgs =
        com.pulumi.azurenative.security.AssignmentArgs.builder()
            .additionalData(additionalData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .assignedComponent(assignedComponent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .assignedStandard(assignedStandard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .assignmentId(assignmentId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .effect(effect?.applyValue({ args0 -> args0 }))
            .expiresOn(expiresOn?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AssignmentArgs].
 */
@PulumiTagMarker
public class AssignmentArgsBuilder internal constructor() {
    private var additionalData: Output<AssignmentPropertiesAdditionalDataArgs>? = null

    private var assignedComponent: Output<AssignedComponentItemArgs>? = null

    private var assignedStandard: Output<AssignedStandardItemArgs>? = null

    private var assignmentId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var effect: Output<String>? = null

    private var expiresOn: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Additional data about the assignment
     */
    @JvmName("ccgkrsbomjvyplwg")
    public suspend fun additionalData(`value`: Output<AssignmentPropertiesAdditionalDataArgs>) {
        this.additionalData = value
    }

    /**
     * @param value Component item with key as applied to this standard assignment over the given scope
     */
    @JvmName("jwpgvacyiqtltpmy")
    public suspend fun assignedComponent(`value`: Output<AssignedComponentItemArgs>) {
        this.assignedComponent = value
    }

    /**
     * @param value Standard item with key as applied to this standard assignment over the given scope
     */
    @JvmName("jorbbyaanqkjuemb")
    public suspend fun assignedStandard(`value`: Output<AssignedStandardItemArgs>) {
        this.assignedStandard = value
    }

    /**
     * @param value The security assignment key - unique key for the standard assignment
     */
    @JvmName("hadvkbebvqsbuqmc")
    public suspend fun assignmentId(`value`: Output<String>) {
        this.assignmentId = value
    }

    /**
     * @param value description of the standardAssignment
     */
    @JvmName("dptnuesbeekrpnur")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value display name of the standardAssignment
     */
    @JvmName("eshcsovwtfnkvevn")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value expected effect of this assignment (Disable/Exempt/etc)
     */
    @JvmName("gxindyhuhnleliux")
    public suspend fun effect(`value`: Output<String>) {
        this.effect = value
    }

    /**
     * @param value Expiration date of this assignment as a full ISO date
     */
    @JvmName("uibkmhkaoynfxswi")
    public suspend fun expiresOn(`value`: Output<String>) {
        this.expiresOn = value
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("onomjjhjcidosjxt")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Location where the resource is stored
     */
    @JvmName("xsttroamkxaqthnx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("henmpipkpvfrhavv")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("dgasqkotiybywmim")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Scope to which the standardAssignment applies - can be a subscription path or a resource group under that subscription
     */
    @JvmName("ldmkrdhomgikebiy")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value A list of key value pairs that describe the resource.
     */
    @JvmName("dxyesuvktjpynemg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Additional data about the assignment
     */
    @JvmName("aslcfuhyjykndyhv")
    public suspend fun additionalData(`value`: AssignmentPropertiesAdditionalDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalData = mapped
    }

    /**
     * @param argument Additional data about the assignment
     */
    @JvmName("bqvxqfdlaqcjnqvt")
    public suspend
    fun additionalData(argument: suspend AssignmentPropertiesAdditionalDataArgsBuilder.() -> Unit) {
        val toBeMapped = AssignmentPropertiesAdditionalDataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.additionalData = mapped
    }

    /**
     * @param value Component item with key as applied to this standard assignment over the given scope
     */
    @JvmName("nckflkmjloeueunf")
    public suspend fun assignedComponent(`value`: AssignedComponentItemArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedComponent = mapped
    }

    /**
     * @param argument Component item with key as applied to this standard assignment over the given scope
     */
    @JvmName("ajdhqhniaaokmrjs")
    public suspend
    fun assignedComponent(argument: suspend AssignedComponentItemArgsBuilder.() -> Unit) {
        val toBeMapped = AssignedComponentItemArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.assignedComponent = mapped
    }

    /**
     * @param value Standard item with key as applied to this standard assignment over the given scope
     */
    @JvmName("qbivudwowkdvhval")
    public suspend fun assignedStandard(`value`: AssignedStandardItemArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedStandard = mapped
    }

    /**
     * @param argument Standard item with key as applied to this standard assignment over the given scope
     */
    @JvmName("hnxpyokvxtlplygv")
    public suspend
    fun assignedStandard(argument: suspend AssignedStandardItemArgsBuilder.() -> Unit) {
        val toBeMapped = AssignedStandardItemArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.assignedStandard = mapped
    }

    /**
     * @param value The security assignment key - unique key for the standard assignment
     */
    @JvmName("avmhhyikjovvrwnx")
    public suspend fun assignmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentId = mapped
    }

    /**
     * @param value description of the standardAssignment
     */
    @JvmName("xsuxesvjqibbhvmt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value display name of the standardAssignment
     */
    @JvmName("hmiahsnuqdfcynms")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value expected effect of this assignment (Disable/Exempt/etc)
     */
    @JvmName("kddyjmrlmvcvcjdc")
    public suspend fun effect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value Expiration date of this assignment as a full ISO date
     */
    @JvmName("yahjlfgthllwwxub")
    public suspend fun expiresOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresOn = mapped
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("roovrvuiuoxhfoqy")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Location where the resource is stored
     */
    @JvmName("uhhttaphipxixbww")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("udlehabqfqdalcqp")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("kfbholqrvvewddrx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Scope to which the standardAssignment applies - can be a subscription path or a resource group under that subscription
     */
    @JvmName("adamhyxwnnmcyyve")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value A list of key value pairs that describe the resource.
     */
    @JvmName("nlxpvndeouauyhwy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of key value pairs that describe the resource.
     */
    @JvmName("vsaluhtayttcsuhs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AssignmentArgs = AssignmentArgs(
        additionalData = additionalData,
        assignedComponent = assignedComponent,
        assignedStandard = assignedStandard,
        assignmentId = assignmentId,
        description = description,
        displayName = displayName,
        effect = effect,
        expiresOn = expiresOn,
        kind = kind,
        location = location,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        scope = scope,
        tags = tags,
    )
}
