@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.DevOpsConfigurationPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.security.kotlin.outputs.DevOpsConfigurationPropertiesResponse.Companion.toKotlin as devOpsConfigurationPropertiesResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DevOpsConfiguration].
 */
@PulumiTagMarker
public class DevOpsConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevOpsConfigurationArgs = DevOpsConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevOpsConfigurationArgsBuilder.() -> Unit) {
        val builder = DevOpsConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DevOpsConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.security.DevOpsConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DevOpsConfiguration(builtJavaResource)
    }
}

/**
 * DevOps Configuration resource.
 * Azure REST API version: 2023-09-01-preview.
 * Other available API versions: 2024-04-01.
 * ## Example Usage
 * ### CreateOrUpdate_DevOpsConfigurations_OnboardCurrentAndFuture
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devOpsConfiguration = new AzureNative.Security.DevOpsConfiguration("devOpsConfiguration", new()
 *     {
 *         Properties = new AzureNative.Security.Inputs.DevOpsConfigurationPropertiesArgs
 *         {
 *             Authorization = new AzureNative.Security.Inputs.AuthorizationArgs
 *             {
 *                 Code = "00000000000000000000",
 *             },
 *             AutoDiscovery = AzureNative.Security.AutoDiscovery.Enabled,
 *         },
 *         ResourceGroupName = "myRg",
 *         SecurityConnectorName = "mySecurityConnectorName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDevOpsConfiguration(ctx, "devOpsConfiguration", &security.DevOpsConfigurationArgs{
 * 			Properties: &security.DevOpsConfigurationPropertiesArgs{
 * 				Authorization: &security.AuthorizationArgs{
 * 					Code: pulumi.String("00000000000000000000"),
 * 				},
 * 				AutoDiscovery: pulumi.String(security.AutoDiscoveryEnabled),
 * 			},
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			SecurityConnectorName: pulumi.String("mySecurityConnectorName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DevOpsConfiguration;
 * import com.pulumi.azurenative.security.DevOpsConfigurationArgs;
 * import com.pulumi.azurenative.security.inputs.DevOpsConfigurationPropertiesArgs;
 * import com.pulumi.azurenative.security.inputs.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devOpsConfiguration = new DevOpsConfiguration("devOpsConfiguration", DevOpsConfigurationArgs.builder()
 *             .properties(DevOpsConfigurationPropertiesArgs.builder()
 *                 .authorization(AuthorizationArgs.builder()
 *                     .code("00000000000000000000")
 *                     .build())
 *                 .autoDiscovery("Enabled")
 *                 .build())
 *             .resourceGroupName("myRg")
 *             .securityConnectorName("mySecurityConnectorName")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate_DevOpsConfigurations_OnboardCurrentOnly
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devOpsConfiguration = new AzureNative.Security.DevOpsConfiguration("devOpsConfiguration", new()
 *     {
 *         Properties = new AzureNative.Security.Inputs.DevOpsConfigurationPropertiesArgs
 *         {
 *             Authorization = new AzureNative.Security.Inputs.AuthorizationArgs
 *             {
 *                 Code = "00000000000000000000",
 *             },
 *             AutoDiscovery = AzureNative.Security.AutoDiscovery.Disabled,
 *         },
 *         ResourceGroupName = "myRg",
 *         SecurityConnectorName = "mySecurityConnectorName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDevOpsConfiguration(ctx, "devOpsConfiguration", &security.DevOpsConfigurationArgs{
 * 			Properties: &security.DevOpsConfigurationPropertiesArgs{
 * 				Authorization: &security.AuthorizationArgs{
 * 					Code: pulumi.String("00000000000000000000"),
 * 				},
 * 				AutoDiscovery: pulumi.String(security.AutoDiscoveryDisabled),
 * 			},
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			SecurityConnectorName: pulumi.String("mySecurityConnectorName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DevOpsConfiguration;
 * import com.pulumi.azurenative.security.DevOpsConfigurationArgs;
 * import com.pulumi.azurenative.security.inputs.DevOpsConfigurationPropertiesArgs;
 * import com.pulumi.azurenative.security.inputs.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devOpsConfiguration = new DevOpsConfiguration("devOpsConfiguration", DevOpsConfigurationArgs.builder()
 *             .properties(DevOpsConfigurationPropertiesArgs.builder()
 *                 .authorization(AuthorizationArgs.builder()
 *                     .code("00000000000000000000")
 *                     .build())
 *                 .autoDiscovery("Disabled")
 *                 .build())
 *             .resourceGroupName("myRg")
 *             .securityConnectorName("mySecurityConnectorName")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate_DevOpsConfigurations_OnboardSelected
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devOpsConfiguration = new AzureNative.Security.DevOpsConfiguration("devOpsConfiguration", new()
 *     {
 *         Properties = new AzureNative.Security.Inputs.DevOpsConfigurationPropertiesArgs
 *         {
 *             Authorization = new AzureNative.Security.Inputs.AuthorizationArgs
 *             {
 *                 Code = "00000000000000000000",
 *             },
 *             AutoDiscovery = AzureNative.Security.AutoDiscovery.Disabled,
 *             TopLevelInventoryList = new[]
 *             {
 *                 "org1",
 *                 "org2",
 *             },
 *         },
 *         ResourceGroupName = "myRg",
 *         SecurityConnectorName = "mySecurityConnectorName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDevOpsConfiguration(ctx, "devOpsConfiguration", &security.DevOpsConfigurationArgs{
 * 			Properties: &security.DevOpsConfigurationPropertiesArgs{
 * 				Authorization: &security.AuthorizationArgs{
 * 					Code: pulumi.String("00000000000000000000"),
 * 				},
 * 				AutoDiscovery: pulumi.String(security.AutoDiscoveryDisabled),
 * 				TopLevelInventoryList: pulumi.StringArray{
 * 					pulumi.String("org1"),
 * 					pulumi.String("org2"),
 * 				},
 * 			},
 * 			ResourceGroupName:     pulumi.String("myRg"),
 * 			SecurityConnectorName: pulumi.String("mySecurityConnectorName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DevOpsConfiguration;
 * import com.pulumi.azurenative.security.DevOpsConfigurationArgs;
 * import com.pulumi.azurenative.security.inputs.DevOpsConfigurationPropertiesArgs;
 * import com.pulumi.azurenative.security.inputs.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devOpsConfiguration = new DevOpsConfiguration("devOpsConfiguration", DevOpsConfigurationArgs.builder()
 *             .properties(DevOpsConfigurationPropertiesArgs.builder()
 *                 .authorization(AuthorizationArgs.builder()
 *                     .code("00000000000000000000")
 *                     .build())
 *                 .autoDiscovery("Disabled")
 *                 .topLevelInventoryList(
 *                     "org1",
 *                     "org2")
 *                 .build())
 *             .resourceGroupName("myRg")
 *             .securityConnectorName("mySecurityConnectorName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:DevOpsConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default
 * ```
 */
public class DevOpsConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.security.DevOpsConfiguration,
) : KotlinCustomResource(javaResource, DevOpsConfigurationMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * DevOps Configuration properties.
     */
    public val properties: Output<DevOpsConfigurationPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                devOpsConfigurationPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DevOpsConfigurationMapper : ResourceMapper<DevOpsConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.DevOpsConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): DevOpsConfiguration = DevOpsConfiguration(
        javaResource
            as com.pulumi.azurenative.security.DevOpsConfiguration,
    )
}

/**
 * @see [DevOpsConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevOpsConfiguration].
 */
public suspend fun devOpsConfiguration(
    name: String,
    block: suspend DevOpsConfigurationResourceBuilder.() -> Unit,
): DevOpsConfiguration {
    val builder = DevOpsConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevOpsConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devOpsConfiguration(name: String): DevOpsConfiguration {
    val builder = DevOpsConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
