@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.AllowlistCustomAlertRuleResponse
import com.pulumi.azurenative.security.kotlin.outputs.DenylistCustomAlertRuleResponse
import com.pulumi.azurenative.security.kotlin.outputs.ThresholdCustomAlertRuleResponse
import com.pulumi.azurenative.security.kotlin.outputs.TimeWindowCustomAlertRuleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.security.kotlin.outputs.AllowlistCustomAlertRuleResponse.Companion.toKotlin as allowlistCustomAlertRuleResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.DenylistCustomAlertRuleResponse.Companion.toKotlin as denylistCustomAlertRuleResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.ThresholdCustomAlertRuleResponse.Companion.toKotlin as thresholdCustomAlertRuleResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.TimeWindowCustomAlertRuleResponse.Companion.toKotlin as timeWindowCustomAlertRuleResponseToKotlin

/**
 * Builder for [DeviceSecurityGroup].
 */
@PulumiTagMarker
public class DeviceSecurityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeviceSecurityGroupArgs = DeviceSecurityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeviceSecurityGroupArgsBuilder.() -> Unit) {
        val builder = DeviceSecurityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeviceSecurityGroup {
        val builtJavaResource =
            com.pulumi.azurenative.security.DeviceSecurityGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DeviceSecurityGroup(builtJavaResource)
    }
}

/**
 * The device security group resource
 * Azure REST API version: 2019-08-01. Prior API version in Azure Native 1.x: 2019-08-01.
 * ## Example Usage
 * ### Create or update a device security group for the specified IoT hub resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deviceSecurityGroup = new AzureNative.Security.DeviceSecurityGroup("deviceSecurityGroup", new()
 *     {
 *         DeviceSecurityGroupName = "samplesecuritygroup",
 *         ResourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Devices/iotHubs/sampleiothub",
 *         TimeWindowRules = new[]
 *         {
 *             null,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewDeviceSecurityGroup(ctx, "deviceSecurityGroup", &security.DeviceSecurityGroupArgs{
 * 			DeviceSecurityGroupName: pulumi.String("samplesecuritygroup"),
 * 			ResourceId:              pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Devices/iotHubs/sampleiothub"),
 * 			TimeWindowRules: security.TimeWindowCustomAlertRuleArray{
 * 				nil,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.DeviceSecurityGroup;
 * import com.pulumi.azurenative.security.DeviceSecurityGroupArgs;
 * import com.pulumi.azurenative.security.inputs.TimeWindowCustomAlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deviceSecurityGroup = new DeviceSecurityGroup("deviceSecurityGroup", DeviceSecurityGroupArgs.builder()
 *             .deviceSecurityGroupName("samplesecuritygroup")
 *             .resourceId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Devices/iotHubs/sampleiothub")
 *             .timeWindowRules()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:DeviceSecurityGroup samplesecuritygroup /{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}
 * ```
 */
public class DeviceSecurityGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.security.DeviceSecurityGroup,
) : KotlinCustomResource(javaResource, DeviceSecurityGroupMapper) {
    /**
     * The allow-list custom alert rules.
     */
    public val allowlistRules: Output<List<AllowlistCustomAlertRuleResponse>>?
        get() = javaResource.allowlistRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        allowlistCustomAlertRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The deny-list custom alert rules.
     */
    public val denylistRules: Output<List<DenylistCustomAlertRuleResponse>>?
        get() = javaResource.denylistRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        denylistCustomAlertRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of custom alert threshold rules.
     */
    public val thresholdRules: Output<List<ThresholdCustomAlertRuleResponse>>?
        get() = javaResource.thresholdRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        thresholdCustomAlertRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of custom alert time-window rules.
     */
    public val timeWindowRules: Output<List<TimeWindowCustomAlertRuleResponse>>?
        get() = javaResource.timeWindowRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        timeWindowCustomAlertRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeviceSecurityGroupMapper : ResourceMapper<DeviceSecurityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.DeviceSecurityGroup::class == javaResource::class

    override fun map(javaResource: Resource): DeviceSecurityGroup = DeviceSecurityGroup(
        javaResource
            as com.pulumi.azurenative.security.DeviceSecurityGroup,
    )
}

/**
 * @see [DeviceSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeviceSecurityGroup].
 */
public suspend fun deviceSecurityGroup(
    name: String,
    block: suspend DeviceSecurityGroupResourceBuilder.() -> Unit,
): DeviceSecurityGroup {
    val builder = DeviceSecurityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeviceSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deviceSecurityGroup(name: String): DeviceSecurityGroup {
    val builder = DeviceSecurityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
