@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.GovernanceAssignmentAdditionalDataResponse
import com.pulumi.azurenative.security.kotlin.outputs.GovernanceEmailNotificationResponse
import com.pulumi.azurenative.security.kotlin.outputs.RemediationEtaResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.security.kotlin.outputs.GovernanceAssignmentAdditionalDataResponse.Companion.toKotlin as governanceAssignmentAdditionalDataResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GovernanceEmailNotificationResponse.Companion.toKotlin as governanceEmailNotificationResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.RemediationEtaResponse.Companion.toKotlin as remediationEtaResponseToKotlin

/**
 * Builder for [GovernanceAssignment].
 */
@PulumiTagMarker
public class GovernanceAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GovernanceAssignmentArgs = GovernanceAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GovernanceAssignmentArgsBuilder.() -> Unit) {
        val builder = GovernanceAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GovernanceAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.security.GovernanceAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GovernanceAssignment(builtJavaResource)
    }
}

/**
 * Governance assignment over a given scope
 * Azure REST API version: 2022-01-01-preview.
 * ## Example Usage
 * ### Create Governance assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var governanceAssignment = new AzureNative.Security.GovernanceAssignment("governanceAssignment", new()
 *     {
 *         AdditionalData = new AzureNative.Security.Inputs.GovernanceAssignmentAdditionalDataArgs
 *         {
 *             TicketLink = "https://snow.com",
 *             TicketNumber = 123123,
 *             TicketStatus = "Active",
 *         },
 *         AssessmentName = "6b9421dd-5555-2251-9b3d-2be58e2f82cd",
 *         AssignmentKey = "6634ff9f-127b-4bf2-8e6e-b1737f5e789c",
 *         GovernanceEmailNotification = new AzureNative.Security.Inputs.GovernanceEmailNotificationArgs
 *         {
 *             DisableManagerEmailNotification = false,
 *             DisableOwnerEmailNotification = false,
 *         },
 *         IsGracePeriod = true,
 *         Owner = "user@contoso.com",
 *         RemediationDueDate = "2022-01-07T13:00:00.0000000Z",
 *         RemediationEta = new AzureNative.Security.Inputs.RemediationEtaArgs
 *         {
 *             Eta = "2022-01-08T13:00:00.0000000Z",
 *             Justification = "Justification of ETA",
 *         },
 *         Scope = "subscriptions/c32e05d9-7207-4e22-bdf4-4f7d9c72e5fd/resourceGroups/compute_servers/providers/Microsoft.Compute/virtualMachines/win2012",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewGovernanceAssignment(ctx, "governanceAssignment", &security.GovernanceAssignmentArgs{
 * 			AdditionalData: &security.GovernanceAssignmentAdditionalDataArgs{
 * 				TicketLink:   pulumi.String("https://snow.com"),
 * 				TicketNumber: pulumi.Int(123123),
 * 				TicketStatus: pulumi.String("Active"),
 * 			},
 * 			AssessmentName: pulumi.String("6b9421dd-5555-2251-9b3d-2be58e2f82cd"),
 * 			AssignmentKey:  pulumi.String("6634ff9f-127b-4bf2-8e6e-b1737f5e789c"),
 * 			GovernanceEmailNotification: &security.GovernanceEmailNotificationArgs{
 * 				DisableManagerEmailNotification: pulumi.Bool(false),
 * 				DisableOwnerEmailNotification:   pulumi.Bool(false),
 * 			},
 * 			IsGracePeriod:      pulumi.Bool(true),
 * 			Owner:              pulumi.String("user@contoso.com"),
 * 			RemediationDueDate: pulumi.String("2022-01-07T13:00:00.0000000Z"),
 * 			RemediationEta: &security.RemediationEtaArgs{
 * 				Eta:           pulumi.String("2022-01-08T13:00:00.0000000Z"),
 * 				Justification: pulumi.String("Justification of ETA"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/c32e05d9-7207-4e22-bdf4-4f7d9c72e5fd/resourceGroups/compute_servers/providers/Microsoft.Compute/virtualMachines/win2012"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.GovernanceAssignment;
 * import com.pulumi.azurenative.security.GovernanceAssignmentArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceAssignmentAdditionalDataArgs;
 * import com.pulumi.azurenative.security.inputs.GovernanceEmailNotificationArgs;
 * import com.pulumi.azurenative.security.inputs.RemediationEtaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var governanceAssignment = new GovernanceAssignment("governanceAssignment", GovernanceAssignmentArgs.builder()
 *             .additionalData(GovernanceAssignmentAdditionalDataArgs.builder()
 *                 .ticketLink("https://snow.com")
 *                 .ticketNumber(123123)
 *                 .ticketStatus("Active")
 *                 .build())
 *             .assessmentName("6b9421dd-5555-2251-9b3d-2be58e2f82cd")
 *             .assignmentKey("6634ff9f-127b-4bf2-8e6e-b1737f5e789c")
 *             .governanceEmailNotification(GovernanceEmailNotificationArgs.builder()
 *                 .disableManagerEmailNotification(false)
 *                 .disableOwnerEmailNotification(false)
 *                 .build())
 *             .isGracePeriod(true)
 *             .owner("user@contoso.com")
 *             .remediationDueDate("2022-01-07T13:00:00.0000000Z")
 *             .remediationEta(RemediationEtaArgs.builder()
 *                 .eta("2022-01-08T13:00:00.0000000Z")
 *                 .justification("Justification of ETA")
 *                 .build())
 *             .scope("subscriptions/c32e05d9-7207-4e22-bdf4-4f7d9c72e5fd/resourceGroups/compute_servers/providers/Microsoft.Compute/virtualMachines/win2012")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:GovernanceAssignment 6634ff9f-127b-4bf2-8e6e-b1737f5e789c /{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}
 * ```
 */
public class GovernanceAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.security.GovernanceAssignment,
) : KotlinCustomResource(javaResource, GovernanceAssignmentMapper) {
    /**
     * The additional data for the governance assignment - e.g. links to ticket (optional), see example
     */
    public val additionalData: Output<GovernanceAssignmentAdditionalDataResponse>?
        get() = javaResource.additionalData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    governanceAssignmentAdditionalDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
     */
    public val governanceEmailNotification: Output<GovernanceEmailNotificationResponse>?
        get() = javaResource.governanceEmailNotification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> governanceEmailNotificationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Defines whether there is a grace period on the governance assignment
     */
    public val isGracePeriod: Output<Boolean>?
        get() = javaResource.isGracePeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Owner for the governance assignment - e.g. user@contoso.com - see example
     */
    public val owner: Output<String>?
        get() = javaResource.owner().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The remediation due-date - after this date Secure Score will be affected (in case of  active grace-period)
     */
    public val remediationDueDate: Output<String>
        get() = javaResource.remediationDueDate().applyValue({ args0 -> args0 })

    /**
     * The ETA (estimated time of arrival) for remediation (optional), see example
     */
    public val remediationEta: Output<RemediationEtaResponse>?
        get() = javaResource.remediationEta().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> remediationEtaResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GovernanceAssignmentMapper : ResourceMapper<GovernanceAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.GovernanceAssignment::class == javaResource::class

    override fun map(javaResource: Resource): GovernanceAssignment = GovernanceAssignment(
        javaResource
            as com.pulumi.azurenative.security.GovernanceAssignment,
    )
}

/**
 * @see [GovernanceAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GovernanceAssignment].
 */
public suspend fun governanceAssignment(
    name: String,
    block: suspend GovernanceAssignmentResourceBuilder.() -> Unit,
): GovernanceAssignment {
    val builder = GovernanceAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GovernanceAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun governanceAssignment(name: String): GovernanceAssignment {
    val builder = GovernanceAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
