@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.AdditionalWorkspacesPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.RecommendationConfigurationPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.security.kotlin.outputs.UserDefinedResourcesPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.security.kotlin.outputs.AdditionalWorkspacesPropertiesResponse.Companion.toKotlin as additionalWorkspacesPropertiesResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.RecommendationConfigurationPropertiesResponse.Companion.toKotlin as recommendationConfigurationPropertiesResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.UserDefinedResourcesPropertiesResponse.Companion.toKotlin as userDefinedResourcesPropertiesResponseToKotlin

/**
 * Builder for [IotSecuritySolution].
 */
@PulumiTagMarker
public class IotSecuritySolutionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IotSecuritySolutionArgs = IotSecuritySolutionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IotSecuritySolutionArgsBuilder.() -> Unit) {
        val builder = IotSecuritySolutionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IotSecuritySolution {
        val builtJavaResource =
            com.pulumi.azurenative.security.IotSecuritySolution(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IotSecuritySolution(builtJavaResource)
    }
}

/**
 * IoT Security solution configuration and resource information.
 * Azure REST API version: 2019-08-01. Prior API version in Azure Native 1.x: 2019-08-01.
 * Other available API versions: 2017-08-01-preview.
 * ## Example Usage
 * ### Create or update a IoT security solution
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotSecuritySolution = new AzureNative.Security.IotSecuritySolution("iotSecuritySolution", new()
 *     {
 *         DisabledDataSources = new[] {},
 *         DisplayName = "Solution Default",
 *         Export = new[] {},
 *         IotHubs = new[]
 *         {
 *             "/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub",
 *         },
 *         Location = "East Us",
 *         RecommendationsConfiguration = new[]
 *         {
 *             new AzureNative.Security.Inputs.RecommendationConfigurationPropertiesArgs
 *             {
 *                 RecommendationType = AzureNative.Security.RecommendationType.IoT_OpenPorts,
 *                 Status = AzureNative.Security.RecommendationConfigStatus.Disabled,
 *             },
 *             new AzureNative.Security.Inputs.RecommendationConfigurationPropertiesArgs
 *             {
 *                 RecommendationType = AzureNative.Security.RecommendationType.IoT_SharedCredentials,
 *                 Status = AzureNative.Security.RecommendationConfigStatus.Disabled,
 *             },
 *         },
 *         ResourceGroupName = "MyGroup",
 *         SolutionName = "default",
 *         Status = AzureNative.Security.SecuritySolutionStatus.Enabled,
 *         Tags = null,
 *         UnmaskedIpLoggingStatus = AzureNative.Security.UnmaskedIpLoggingStatus.Enabled,
 *         UserDefinedResources = new AzureNative.Security.Inputs.UserDefinedResourcesPropertiesArgs
 *         {
 *             Query = "where type != \"microsoft.devices/iothubs\" | where name contains \"iot\"",
 *             QuerySubscriptions = new[]
 *             {
 *                 "075423e9-7d33-4166-8bdf-3920b04e3735",
 *             },
 *         },
 *         Workspace = "/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewIotSecuritySolution(ctx, "iotSecuritySolution", &security.IotSecuritySolutionArgs{
 * 			DisabledDataSources: pulumi.StringArray{},
 * 			DisplayName:         pulumi.String("Solution Default"),
 * 			Export:              pulumi.StringArray{},
 * 			IotHubs: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub"),
 * 			},
 * 			Location: pulumi.String("East Us"),
 * 			RecommendationsConfiguration: security.RecommendationConfigurationPropertiesArray{
 * 				&security.RecommendationConfigurationPropertiesArgs{
 * 					RecommendationType: pulumi.String(security.RecommendationType_IoT_OpenPorts),
 * 					Status:             pulumi.String(security.RecommendationConfigStatusDisabled),
 * 				},
 * 				&security.RecommendationConfigurationPropertiesArgs{
 * 					RecommendationType: pulumi.String(security.RecommendationType_IoT_SharedCredentials),
 * 					Status:             pulumi.String(security.RecommendationConfigStatusDisabled),
 * 				},
 * 			},
 * 			ResourceGroupName:       pulumi.String("MyGroup"),
 * 			SolutionName:            pulumi.String("default"),
 * 			Status:                  pulumi.String(security.SecuritySolutionStatusEnabled),
 * 			Tags:                    nil,
 * 			UnmaskedIpLoggingStatus: pulumi.String(security.UnmaskedIpLoggingStatusEnabled),
 * 			UserDefinedResources: &security.UserDefinedResourcesPropertiesArgs{
 * 				Query: pulumi.String("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
 * 				QuerySubscriptions: pulumi.StringArray{
 * 					pulumi.String("075423e9-7d33-4166-8bdf-3920b04e3735"),
 * 				},
 * 			},
 * 			Workspace: pulumi.String("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.IotSecuritySolution;
 * import com.pulumi.azurenative.security.IotSecuritySolutionArgs;
 * import com.pulumi.azurenative.security.inputs.RecommendationConfigurationPropertiesArgs;
 * import com.pulumi.azurenative.security.inputs.UserDefinedResourcesPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotSecuritySolution = new IotSecuritySolution("iotSecuritySolution", IotSecuritySolutionArgs.builder()
 *             .disabledDataSources()
 *             .displayName("Solution Default")
 *             .export()
 *             .iotHubs("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")
 *             .location("East Us")
 *             .recommendationsConfiguration(
 *                 RecommendationConfigurationPropertiesArgs.builder()
 *                     .recommendationType("IoT_OpenPorts")
 *                     .status("Disabled")
 *                     .build(),
 *                 RecommendationConfigurationPropertiesArgs.builder()
 *                     .recommendationType("IoT_SharedCredentials")
 *                     .status("Disabled")
 *                     .build())
 *             .resourceGroupName("MyGroup")
 *             .solutionName("default")
 *             .status("Enabled")
 *             .tags()
 *             .unmaskedIpLoggingStatus("Enabled")
 *             .userDefinedResources(UserDefinedResourcesPropertiesArgs.builder()
 *                 .query("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\"")
 *                 .querySubscriptions("075423e9-7d33-4166-8bdf-3920b04e3735")
 *                 .build())
 *             .workspace("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:IotSecuritySolution default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/iotSecuritySolutions/{solutionName}
 * ```
 */
public class IotSecuritySolution internal constructor(
    override val javaResource: com.pulumi.azurenative.security.IotSecuritySolution,
) : KotlinCustomResource(javaResource, IotSecuritySolutionMapper) {
    /**
     * List of additional workspaces
     */
    public val additionalWorkspaces: Output<List<AdditionalWorkspacesPropertiesResponse>>?
        get() = javaResource.additionalWorkspaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        additionalWorkspacesPropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of resources that were automatically discovered as relevant to the security solution.
     */
    public val autoDiscoveredResources: Output<List<String>>
        get() = javaResource.autoDiscoveredResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Disabled data sources. Disabling these data sources compromises the system.
     */
    public val disabledDataSources: Output<List<String>>?
        get() = javaResource.disabledDataSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Resource display name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * List of additional options for exporting to workspace data.
     */
    public val export: Output<List<String>>?
        get() = javaResource.export().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * IoT Hub resource IDs
     */
    public val iotHubs: Output<List<String>>
        get() = javaResource.iotHubs().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of the configuration status for each recommendation type.
     */
    public val recommendationsConfiguration:
        Output<List<RecommendationConfigurationPropertiesResponse>>?
        get() = javaResource.recommendationsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        recommendationConfigurationPropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Status of the IoT Security solution.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unmasked IP address logging status
     */
    public val unmaskedIpLoggingStatus: Output<String>?
        get() = javaResource.unmaskedIpLoggingStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Properties of the IoT Security solution's user defined resources.
     */
    public val userDefinedResources: Output<UserDefinedResourcesPropertiesResponse>?
        get() = javaResource.userDefinedResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> userDefinedResourcesPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Workspace resource ID
     */
    public val workspace: Output<String>?
        get() = javaResource.workspace().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object IotSecuritySolutionMapper : ResourceMapper<IotSecuritySolution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.IotSecuritySolution::class == javaResource::class

    override fun map(javaResource: Resource): IotSecuritySolution = IotSecuritySolution(
        javaResource
            as com.pulumi.azurenative.security.IotSecuritySolution,
    )
}

/**
 * @see [IotSecuritySolution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IotSecuritySolution].
 */
public suspend fun iotSecuritySolution(
    name: String,
    block: suspend IotSecuritySolutionResourceBuilder.() -> Unit,
): IotSecuritySolution {
    val builder = IotSecuritySolutionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IotSecuritySolution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iotSecuritySolution(name: String): IotSecuritySolution {
    val builder = IotSecuritySolutionResourceBuilder()
    builder.name(name)
    return builder.build()
}
