@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.JitNetworkAccessPolicyArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.JitNetworkAccessPolicyVirtualMachineArgs
import com.pulumi.azurenative.security.kotlin.inputs.JitNetworkAccessPolicyVirtualMachineArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.JitNetworkAccessRequestArgs
import com.pulumi.azurenative.security.kotlin.inputs.JitNetworkAccessRequestArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2020-01-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create JIT network access policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jitNetworkAccessPolicy = new AzureNative.Security.JitNetworkAccessPolicy("jitNetworkAccessPolicy", new()
 *     {
 *         AscLocation = "westeurope",
 *         JitNetworkAccessPolicyName = "default",
 *         Kind = "Basic",
 *         Requests = new[]
 *         {
 *             new AzureNative.Security.Inputs.JitNetworkAccessRequestArgs
 *             {
 *                 Requestor = "barbara@contoso.com",
 *                 StartTimeUtc = "2018-05-17T08:06:45.5691611Z",
 *                 VirtualMachines = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.JitNetworkAccessRequestVirtualMachineArgs
 *                     {
 *                         Id = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1",
 *                         Ports = new[]
 *                         {
 *                             new AzureNative.Security.Inputs.JitNetworkAccessRequestPortArgs
 *                             {
 *                                 AllowedSourceAddressPrefix = "192.127.0.2",
 *                                 EndTimeUtc = "2018-05-17T09:06:45.5691611Z",
 *                                 Number = 3389,
 *                                 Status = AzureNative.Security.Status.Initiated,
 *                                 StatusReason = AzureNative.Security.StatusReason.UserRequested,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myRg1",
 *         VirtualMachines = new[]
 *         {
 *             new AzureNative.Security.Inputs.JitNetworkAccessPolicyVirtualMachineArgs
 *             {
 *                 Id = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1",
 *                 Ports = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.JitNetworkAccessPortRuleArgs
 *                     {
 *                         AllowedSourceAddressPrefix = "*",
 *                         MaxRequestAccessDuration = "PT3H",
 *                         Number = 22,
 *                         Protocol = AzureNative.Security.Protocol.All,
 *                     },
 *                     new AzureNative.Security.Inputs.JitNetworkAccessPortRuleArgs
 *                     {
 *                         AllowedSourceAddressPrefix = "*",
 *                         MaxRequestAccessDuration = "PT3H",
 *                         Number = 3389,
 *                         Protocol = AzureNative.Security.Protocol.All,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewJitNetworkAccessPolicy(ctx, "jitNetworkAccessPolicy", &security.JitNetworkAccessPolicyArgs{
 * 			AscLocation:                pulumi.String("westeurope"),
 * 			JitNetworkAccessPolicyName: pulumi.String("default"),
 * 			Kind:                       pulumi.String("Basic"),
 * 			Requests: security.JitNetworkAccessRequestArray{
 * 				&security.JitNetworkAccessRequestArgs{
 * 					Requestor:    pulumi.String("barbara@contoso.com"),
 * 					StartTimeUtc: pulumi.String("2018-05-17T08:06:45.5691611Z"),
 * 					VirtualMachines: security.JitNetworkAccessRequestVirtualMachineArray{
 * 						&security.JitNetworkAccessRequestVirtualMachineArgs{
 * 							Id: pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 							Ports: security.JitNetworkAccessRequestPortArray{
 * 								&security.JitNetworkAccessRequestPortArgs{
 * 									AllowedSourceAddressPrefix: pulumi.String("192.127.0.2"),
 * 									EndTimeUtc:                 pulumi.String("2018-05-17T09:06:45.5691611Z"),
 * 									Number:                     pulumi.Int(3389),
 * 									Status:                     pulumi.String(security.StatusInitiated),
 * 									StatusReason:               pulumi.String(security.StatusReasonUserRequested),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg1"),
 * 			VirtualMachines: security.JitNetworkAccessPolicyVirtualMachineArray{
 * 				&security.JitNetworkAccessPolicyVirtualMachineArgs{
 * 					Id: pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 					Ports: security.JitNetworkAccessPortRuleArray{
 * 						&security.JitNetworkAccessPortRuleArgs{
 * 							AllowedSourceAddressPrefix: pulumi.String("*"),
 * 							MaxRequestAccessDuration:   pulumi.String("PT3H"),
 * 							Number:                     pulumi.Int(22),
 * 							Protocol:                   pulumi.String(security.ProtocolAll),
 * 						},
 * 						&security.JitNetworkAccessPortRuleArgs{
 * 							AllowedSourceAddressPrefix: pulumi.String("*"),
 * 							MaxRequestAccessDuration:   pulumi.String("PT3H"),
 * 							Number:                     pulumi.Int(3389),
 * 							Protocol:                   pulumi.String(security.ProtocolAll),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.JitNetworkAccessPolicy;
 * import com.pulumi.azurenative.security.JitNetworkAccessPolicyArgs;
 * import com.pulumi.azurenative.security.inputs.JitNetworkAccessRequestArgs;
 * import com.pulumi.azurenative.security.inputs.JitNetworkAccessPolicyVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jitNetworkAccessPolicy = new JitNetworkAccessPolicy("jitNetworkAccessPolicy", JitNetworkAccessPolicyArgs.builder()
 *             .ascLocation("westeurope")
 *             .jitNetworkAccessPolicyName("default")
 *             .kind("Basic")
 *             .requests(JitNetworkAccessRequestArgs.builder()
 *                 .requestor("barbara@contoso.com")
 *                 .startTimeUtc("2018-05-17T08:06:45.5691611Z")
 *                 .virtualMachines(JitNetworkAccessRequestVirtualMachineArgs.builder()
 *                     .id("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1")
 *                     .ports(JitNetworkAccessRequestPortArgs.builder()
 *                         .allowedSourceAddressPrefix("192.127.0.2")
 *                         .endTimeUtc("2018-05-17T09:06:45.5691611Z")
 *                         .number(3389)
 *                         .status("Initiated")
 *                         .statusReason("UserRequested")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myRg1")
 *             .virtualMachines(JitNetworkAccessPolicyVirtualMachineArgs.builder()
 *                 .id("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1")
 *                 .ports(
 *                     JitNetworkAccessPortRuleArgs.builder()
 *                         .allowedSourceAddressPrefix("*")
 *                         .maxRequestAccessDuration("PT3H")
 *                         .number(22)
 *                         .protocol("*")
 *                         .build(),
 *                     JitNetworkAccessPortRuleArgs.builder()
 *                         .allowedSourceAddressPrefix("*")
 *                         .maxRequestAccessDuration("PT3H")
 *                         .number(3389)
 *                         .protocol("*")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:JitNetworkAccessPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}
 * ```
 * @property ascLocation The location where ASC stores the data of the subscription. can be retrieved from Get locations
 * @property jitNetworkAccessPolicyName Name of a Just-in-Time access configuration policy.
 * @property kind Kind of the resource
 * @property requests
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property virtualMachines Configurations for Microsoft.Compute/virtualMachines resource type.
 */
public data class JitNetworkAccessPolicyArgs(
    public val ascLocation: Output<String>? = null,
    public val jitNetworkAccessPolicyName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val requests: Output<List<JitNetworkAccessRequestArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualMachines: Output<List<JitNetworkAccessPolicyVirtualMachineArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.JitNetworkAccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.security.JitNetworkAccessPolicyArgs =
        com.pulumi.azurenative.security.JitNetworkAccessPolicyArgs.builder()
            .ascLocation(ascLocation?.applyValue({ args0 -> args0 }))
            .jitNetworkAccessPolicyName(jitNetworkAccessPolicyName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .requests(
                requests?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualMachines(
                virtualMachines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JitNetworkAccessPolicyArgs].
 */
@PulumiTagMarker
public class JitNetworkAccessPolicyArgsBuilder internal constructor() {
    private var ascLocation: Output<String>? = null

    private var jitNetworkAccessPolicyName: Output<String>? = null

    private var kind: Output<String>? = null

    private var requests: Output<List<JitNetworkAccessRequestArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualMachines: Output<List<JitNetworkAccessPolicyVirtualMachineArgs>>? = null

    /**
     * @param value The location where ASC stores the data of the subscription. can be retrieved from Get locations
     */
    @JvmName("nwnsisektvopbspk")
    public suspend fun ascLocation(`value`: Output<String>) {
        this.ascLocation = value
    }

    /**
     * @param value Name of a Just-in-Time access configuration policy.
     */
    @JvmName("dkrmuvuqcpjgoajj")
    public suspend fun jitNetworkAccessPolicyName(`value`: Output<String>) {
        this.jitNetworkAccessPolicyName = value
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("gbwsmljbqktljknf")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value
     */
    @JvmName("ymfxyfcucihhuxle")
    public suspend fun requests(`value`: Output<List<JitNetworkAccessRequestArgs>>) {
        this.requests = value
    }

    @JvmName("pqrndevcmmouhwnu")
    public suspend fun requests(vararg values: Output<JitNetworkAccessRequestArgs>) {
        this.requests = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rfvwnbcaljopdkxv")
    public suspend fun requests(values: List<Output<JitNetworkAccessRequestArgs>>) {
        this.requests = Output.all(values)
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("mbagjbutuhduohjr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Configurations for Microsoft.Compute/virtualMachines resource type.
     */
    @JvmName("ymkwgbhqwweorsgo")
    public suspend
    fun virtualMachines(`value`: Output<List<JitNetworkAccessPolicyVirtualMachineArgs>>) {
        this.virtualMachines = value
    }

    @JvmName("bnvfvkfyyychqqcj")
    public suspend fun virtualMachines(
        vararg
        values: Output<JitNetworkAccessPolicyVirtualMachineArgs>,
    ) {
        this.virtualMachines = Output.all(values.asList())
    }

    /**
     * @param values Configurations for Microsoft.Compute/virtualMachines resource type.
     */
    @JvmName("kjhviviuwtsvsteo")
    public suspend
    fun virtualMachines(values: List<Output<JitNetworkAccessPolicyVirtualMachineArgs>>) {
        this.virtualMachines = Output.all(values)
    }

    /**
     * @param value The location where ASC stores the data of the subscription. can be retrieved from Get locations
     */
    @JvmName("thmfiuxrwdcxveob")
    public suspend fun ascLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ascLocation = mapped
    }

    /**
     * @param value Name of a Just-in-Time access configuration policy.
     */
    @JvmName("alsfxadgqjccnprg")
    public suspend fun jitNetworkAccessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jitNetworkAccessPolicyName = mapped
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("wnnurtlpcsnksqxg")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value
     */
    @JvmName("udfonjhsqlxabbtc")
    public suspend fun requests(`value`: List<JitNetworkAccessRequestArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qrshrmgxhdhyoful")
    public suspend
    fun requests(argument: List<suspend JitNetworkAccessRequestArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessRequestArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jmwxrwshxntnqqrt")
    public suspend fun requests(
        vararg
        argument: suspend JitNetworkAccessRequestArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessRequestArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ksrdqkuopewkkupt")
    public suspend fun requests(argument: suspend JitNetworkAccessRequestArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JitNetworkAccessRequestArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    /**
     * @param values
     */
    @JvmName("rummiwxyaeyboxtq")
    public suspend fun requests(vararg values: JitNetworkAccessRequestArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("qgejtqfonyronqsd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Configurations for Microsoft.Compute/virtualMachines resource type.
     */
    @JvmName("sgnvebixfyvhecqm")
    public suspend fun virtualMachines(`value`: List<JitNetworkAccessPolicyVirtualMachineArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    /**
     * @param argument Configurations for Microsoft.Compute/virtualMachines resource type.
     */
    @JvmName("vkbrxcvjfoegqhpw")
    public suspend
    fun virtualMachines(argument: List<suspend JitNetworkAccessPolicyVirtualMachineArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessPolicyVirtualMachineArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument Configurations for Microsoft.Compute/virtualMachines resource type.
     */
    @JvmName("lfjjbpaondrecshg")
    public suspend fun virtualMachines(
        vararg
        argument: suspend JitNetworkAccessPolicyVirtualMachineArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessPolicyVirtualMachineArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument Configurations for Microsoft.Compute/virtualMachines resource type.
     */
    @JvmName("loghceixiumevffk")
    public suspend
    fun virtualMachines(argument: suspend JitNetworkAccessPolicyVirtualMachineArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JitNetworkAccessPolicyVirtualMachineArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param values Configurations for Microsoft.Compute/virtualMachines resource type.
     */
    @JvmName("axldotwpoxkkecos")
    public suspend fun virtualMachines(vararg values: JitNetworkAccessPolicyVirtualMachineArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    internal fun build(): JitNetworkAccessPolicyArgs = JitNetworkAccessPolicyArgs(
        ascLocation = ascLocation,
        jitNetworkAccessPolicyName = jitNetworkAccessPolicyName,
        kind = kind,
        requests = requests,
        resourceGroupName = resourceGroupName,
        virtualMachines = virtualMachines,
    )
}
