@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.ExtensionResponse
import com.pulumi.azurenative.security.kotlin.outputs.ExtensionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Pricing].
 */
@PulumiTagMarker
public class PricingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PricingArgs = PricingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PricingArgsBuilder.() -> Unit) {
        val builder = PricingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Pricing {
        val builtJavaResource = com.pulumi.azurenative.security.Pricing(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pricing(builtJavaResource)
    }
}

/**
 * Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
 * Azure REST API version: 2024-01-01.
 * ## Example Usage
 * ### Update pricing on resource (example for VirtualMachines plan)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pricing = new AzureNative.Security.Pricing("pricing", new()
 *     {
 *         PricingName = "virtualMachines",
 *         PricingTier = AzureNative.Security.PricingTier.Standard,
 *         ScopeId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/DEMO/providers/Microsoft.Compute/virtualMachines/VM-1",
 *         SubPlan = "P1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewPricing(ctx, "pricing", &security.PricingArgs{
 * 			PricingName: pulumi.String("virtualMachines"),
 * 			PricingTier: pulumi.String(security.PricingTierStandard),
 * 			ScopeId:     pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/DEMO/providers/Microsoft.Compute/virtualMachines/VM-1"),
 * 			SubPlan:     pulumi.String("P1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Pricing;
 * import com.pulumi.azurenative.security.PricingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pricing = new Pricing("pricing", PricingArgs.builder()
 *             .pricingName("virtualMachines")
 *             .pricingTier("Standard")
 *             .scopeId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/DEMO/providers/Microsoft.Compute/virtualMachines/VM-1")
 *             .subPlan("P1")
 *             .build());
 *     }
 * }
 * ```
 * ### Update pricing on subscription (example for CloudPosture plan)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pricing = new AzureNative.Security.Pricing("pricing", new()
 *     {
 *         PricingName = "CloudPosture",
 *         PricingTier = AzureNative.Security.PricingTier.Standard,
 *         ScopeId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewPricing(ctx, "pricing", &security.PricingArgs{
 * 			PricingName: pulumi.String("CloudPosture"),
 * 			PricingTier: pulumi.String(security.PricingTierStandard),
 * 			ScopeId:     pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Pricing;
 * import com.pulumi.azurenative.security.PricingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pricing = new Pricing("pricing", PricingArgs.builder()
 *             .pricingName("CloudPosture")
 *             .pricingTier("Standard")
 *             .scopeId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .build());
 *     }
 * }
 * ```
 * ### Update pricing on subscription (example for CloudPosture plan) - partial success
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pricing = new AzureNative.Security.Pricing("pricing", new()
 *     {
 *         PricingName = "CloudPosture",
 *         PricingTier = AzureNative.Security.PricingTier.Standard,
 *         ScopeId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewPricing(ctx, "pricing", &security.PricingArgs{
 * 			PricingName: pulumi.String("CloudPosture"),
 * 			PricingTier: pulumi.String(security.PricingTierStandard),
 * 			ScopeId:     pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Pricing;
 * import com.pulumi.azurenative.security.PricingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pricing = new Pricing("pricing", PricingArgs.builder()
 *             .pricingName("CloudPosture")
 *             .pricingTier("Standard")
 *             .scopeId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .build());
 *     }
 * }
 * ```
 * ### Update pricing on subscription (example for VirtualMachines plan)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pricing = new AzureNative.Security.Pricing("pricing", new()
 *     {
 *         Enforce = AzureNative.Security.Enforce.True,
 *         PricingName = "VirtualMachines",
 *         PricingTier = AzureNative.Security.PricingTier.Standard,
 *         ScopeId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         SubPlan = "P2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewPricing(ctx, "pricing", &security.PricingArgs{
 * 			Enforce:     pulumi.String(security.EnforceTrue),
 * 			PricingName: pulumi.String("VirtualMachines"),
 * 			PricingTier: pulumi.String(security.PricingTierStandard),
 * 			ScopeId:     pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 			SubPlan:     pulumi.String("P2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Pricing;
 * import com.pulumi.azurenative.security.PricingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pricing = new Pricing("pricing", PricingArgs.builder()
 *             .enforce("True")
 *             .pricingName("VirtualMachines")
 *             .pricingTier("Standard")
 *             .scopeId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .subPlan("P2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Pricing VirtualMachines /{scopeId}/providers/Microsoft.Security/pricings/{pricingName}
 * ```
 */
public class Pricing internal constructor(
    override val javaResource: com.pulumi.azurenative.security.Pricing,
) : KotlinCustomResource(javaResource, PricingMapper) {
    /**
     * Optional. True if the plan is deprecated. If there are replacing plans they will appear in `replacedBy` property
     */
    public val deprecated: Output<Boolean>
        get() = javaResource.deprecated().applyValue({ args0 -> args0 })

    /**
     * Optional. If `pricingTier` is `Standard` then this property holds the date of the last time the `pricingTier` was set to `Standard`, when available (e.g 2023-03-01T12:42:42.1921106Z).
     */
    public val enablementTime: Output<String>
        get() = javaResource.enablementTime().applyValue({ args0 -> args0 })

    /**
     * If set to "False", it allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False"). If set to "True", it prevents overrides and forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level pricing.
     */
    public val enforce: Output<String>?
        get() = javaResource.enforce().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Optional. List of extensions offered under a plan.
     */
    public val extensions: Output<List<ExtensionResponse>>?
        get() = javaResource.extensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The duration left for the subscriptions free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
     */
    public val freeTrialRemainingTime: Output<String>
        get() = javaResource.freeTrialRemainingTime().applyValue({ args0 -> args0 })

    /**
     * "inherited" = "True" indicates that the current scope inherits its pricing configuration from its parent. The ID of the parent scope that provides the inherited configuration is displayed in the "inheritedFrom" field. On the other hand, "inherited" = "False" indicates that the current scope has its own pricing configuration explicitly set, and does not inherit from its parent. This field is read only and available only for resource-level pricing.
     */
    public val inherited: Output<String>
        get() = javaResource.inherited().applyValue({ args0 -> args0 })

    /**
     * The id of the scope inherited from. "Null" if not inherited. This field is only available for resource-level pricing.
     */
    public val inheritedFrom: Output<String>
        get() = javaResource.inheritedFrom().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
     */
    public val pricingTier: Output<String>
        get() = javaResource.pricingTier().applyValue({ args0 -> args0 })

    /**
     * Optional. List of plans that replace this plan. This property exists only if this plan is deprecated.
     */
    public val replacedBy: Output<List<String>>
        get() = javaResource.replacedBy().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * This field is available for subscription-level only, and reflects the coverage status of the resources under the subscription. Please note: The "pricingTier" field reflects the plan status of the subscription. However, since the plan status can also be defined at the resource level, there might be misalignment between the subscription's plan status and the resource status. This field helps indicate the coverage status of the resources.
     */
    public val resourcesCoverageStatus: Output<String>
        get() = javaResource.resourcesCoverageStatus().applyValue({ args0 -> args0 })

    /**
     * The sub-plan selected for a Standard pricing configuration, when more than one sub-plan is available. Each sub-plan enables a set of security features. When not specified, full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2', where for resource level only 'P1' sub plan is supported.
     */
    public val subPlan: Output<String>?
        get() = javaResource.subPlan().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PricingMapper : ResourceMapper<Pricing> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.Pricing::class == javaResource::class

    override fun map(javaResource: Resource): Pricing = Pricing(
        javaResource as
            com.pulumi.azurenative.security.Pricing,
    )
}

/**
 * @see [Pricing].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pricing].
 */
public suspend fun pricing(name: String, block: suspend PricingResourceBuilder.() -> Unit):
    Pricing {
    val builder = PricingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pricing].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pricing(name: String): Pricing {
    val builder = PricingResourceBuilder()
    builder.name(name)
    return builder.build()
}
