@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SecurityConnector].
 */
@PulumiTagMarker
public class SecurityConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityConnectorArgs = SecurityConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityConnectorArgsBuilder.() -> Unit) {
        val builder = SecurityConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityConnector {
        val builtJavaResource =
            com.pulumi.azurenative.security.SecurityConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecurityConnector(builtJavaResource)
    }
}

/**
 * The security connector resource.
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * Other available API versions: 2021-07-01-preview, 2023-10-01-preview, 2024-03-01-preview.
 * ## Example Usage
 * ### Create or update a security connector
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityConnector = new AzureNative.Security.SecurityConnector("securityConnector", new()
 *     {
 *         EnvironmentData = new AzureNative.Security.Inputs.AwsEnvironmentDataArgs
 *         {
 *             EnvironmentType = "AwsAccount",
 *         },
 *         EnvironmentName = AzureNative.Security.CloudName.AWS,
 *         HierarchyIdentifier = "exampleHierarchyId",
 *         Location = "Central US",
 *         Offerings = new[]
 *         {
 *             new AzureNative.Security.Inputs.CspmMonitorAwsOfferingArgs
 *             {
 *                 NativeCloudConnection = new AzureNative.Security.Inputs.CspmMonitorAwsOfferingNativeCloudConnectionArgs
 *                 {
 *                     CloudRoleArn = "arn:aws:iam::00000000:role/ASCMonitor",
 *                 },
 *                 OfferingType = "CspmMonitorAws",
 *             },
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *         SecurityConnectorName = "exampleSecurityConnectorName",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSecurityConnector(ctx, "securityConnector", &security.SecurityConnectorArgs{
 * 			EnvironmentData: security.AwsEnvironmentData{
 * 				EnvironmentType: "AwsAccount",
 * 			},
 * 			EnvironmentName:     pulumi.String(security.CloudNameAWS),
 * 			HierarchyIdentifier: pulumi.String("exampleHierarchyId"),
 * 			Location:            pulumi.String("Central US"),
 * 			Offerings: pulumi.Array{
 * 				security.CspmMonitorAwsOffering{
 * 					NativeCloudConnection: security.CspmMonitorAwsOfferingNativeCloudConnection{
 * 						CloudRoleArn: "arn:aws:iam::00000000:role/ASCMonitor",
 * 					},
 * 					OfferingType: "CspmMonitorAws",
 * 				},
 * 			},
 * 			ResourceGroupName:     pulumi.String("exampleResourceGroup"),
 * 			SecurityConnectorName: pulumi.String("exampleSecurityConnectorName"),
 * 			Tags:                  nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SecurityConnector;
 * import com.pulumi.azurenative.security.SecurityConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityConnector = new SecurityConnector("securityConnector", SecurityConnectorArgs.builder()
 *             .environmentData(AwsEnvironmentDataArgs.builder()
 *                 .environmentType("AwsAccount")
 *                 .build())
 *             .environmentName("AWS")
 *             .hierarchyIdentifier("exampleHierarchyId")
 *             .location("Central US")
 *             .offerings(CspmMonitorAwsOfferingArgs.builder()
 *                 .nativeCloudConnection(CspmMonitorAwsOfferingNativeCloudConnectionArgs.builder()
 *                     .cloudRoleArn("arn:aws:iam::00000000:role/ASCMonitor")
 *                     .build())
 *                 .offeringType("CspmMonitorAws")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .securityConnectorName("exampleSecurityConnectorName")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SecurityConnector exampleSecurityConnectorName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}
 * ```
 */
public class SecurityConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.security.SecurityConnector,
) : KotlinCustomResource(javaResource, SecurityConnectorMapper) {
    /**
     * The security connector environment data.
     */
    public val environmentData: Output<Any>?
        get() = javaResource.environmentData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The multi cloud resource's cloud name.
     */
    public val environmentName: Output<String>?
        get() = javaResource.environmentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Entity tag is used for comparing two or more entities from the same requested resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The multi cloud resource identifier (account id in case of AWS connector, project number in case of GCP connector).
     */
    public val hierarchyIdentifier: Output<String>?
        get() = javaResource.hierarchyIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date on which the trial period will end, if applicable. Trial period exists for 30 days after upgrading to payed offerings.
     */
    public val hierarchyIdentifierTrialEndDate: Output<String>
        get() = javaResource.hierarchyIdentifierTrialEndDate().applyValue({ args0 -> args0 })

    /**
     * Kind of the resource
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Location where the resource is stored
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A collection of offerings for the security connector.
     */
    public val offerings: Output<List<Any>>?
        get() = javaResource.offerings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * A list of key value pairs that describe the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityConnectorMapper : ResourceMapper<SecurityConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.SecurityConnector::class == javaResource::class

    override fun map(javaResource: Resource): SecurityConnector = SecurityConnector(
        javaResource as
            com.pulumi.azurenative.security.SecurityConnector,
    )
}

/**
 * @see [SecurityConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityConnector].
 */
public suspend fun securityConnector(
    name: String,
    block: suspend SecurityConnectorResourceBuilder.() -> Unit,
): SecurityConnector {
    val builder = SecurityConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityConnector(name: String): SecurityConnector {
    val builder = SecurityConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
