@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityConnectorApplication].
 */
@PulumiTagMarker
public class SecurityConnectorApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityConnectorApplicationArgs = SecurityConnectorApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityConnectorApplicationArgsBuilder.() -> Unit) {
        val builder = SecurityConnectorApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityConnectorApplication {
        val builtJavaResource =
            com.pulumi.azurenative.security.SecurityConnectorApplication(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecurityConnectorApplication(builtJavaResource)
    }
}

/**
 * Security Application over a given scope
 * Azure REST API version: 2022-07-01-preview. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * ## Example Usage
 * ### Create Application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityConnectorApplication = new AzureNative.Security.SecurityConnectorApplication("securityConnectorApplication", new()
 *     {
 *         ApplicationId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         Description = "An application on critical GCP recommendations",
 *         DisplayName = "GCP Admin's application",
 *         ResourceGroupName = "gcpResourceGroup",
 *         SecurityConnectorName = "gcpconnector",
 *         SourceResourceType = AzureNative.Security.ApplicationSourceResourceType.Assessments,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSecurityConnectorApplication(ctx, "securityConnectorApplication", &security.SecurityConnectorApplicationArgs{
 * 			ApplicationId:         pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			Description:           pulumi.String("An application on critical GCP recommendations"),
 * 			DisplayName:           pulumi.String("GCP Admin's application"),
 * 			ResourceGroupName:     pulumi.String("gcpResourceGroup"),
 * 			SecurityConnectorName: pulumi.String("gcpconnector"),
 * 			SourceResourceType:    pulumi.String(security.ApplicationSourceResourceTypeAssessments),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SecurityConnectorApplication;
 * import com.pulumi.azurenative.security.SecurityConnectorApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityConnectorApplication = new SecurityConnectorApplication("securityConnectorApplication", SecurityConnectorApplicationArgs.builder()
 *             .applicationId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .description("An application on critical GCP recommendations")
 *             .displayName("GCP Admin's application")
 *             .resourceGroupName("gcpResourceGroup")
 *             .securityConnectorName("gcpconnector")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SecurityConnectorApplication 1f3afdf9-d0c9-4c3d-847f-89da613e70a8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/providers/Microsoft.Security/applications/{applicationId}
 * ```
 */
public class SecurityConnectorApplication internal constructor(
    override val javaResource: com.pulumi.azurenative.security.SecurityConnectorApplication,
) : KotlinCustomResource(javaResource, SecurityConnectorApplicationMapper) {
    /**
     * description of the application
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * display name of the application
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The application source, what it affects, e.g. Assessments
     */
    public val sourceResourceType: Output<String>
        get() = javaResource.sourceResourceType().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityConnectorApplicationMapper : ResourceMapper<SecurityConnectorApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.SecurityConnectorApplication::class == javaResource::class

    override fun map(javaResource: Resource): SecurityConnectorApplication =
        SecurityConnectorApplication(
            javaResource as
                com.pulumi.azurenative.security.SecurityConnectorApplication,
        )
}

/**
 * @see [SecurityConnectorApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityConnectorApplication].
 */
public suspend fun securityConnectorApplication(
    name: String,
    block: suspend SecurityConnectorApplicationResourceBuilder.() -> Unit,
):
    SecurityConnectorApplication {
    val builder = SecurityConnectorApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityConnectorApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityConnectorApplication(name: String): SecurityConnectorApplication {
    val builder = SecurityConnectorApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
